/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.tileentity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.UncolossalChest;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.colossalchests.inventory.container.ContainerUncolossalChest;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public class TileUncolossalChest
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile,
INamedContainerProvider,
IChestLid {
    private static final int TICK_MODULUS = 200;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private ITextComponent customName = null;
    private final SimpleInventory inventory = new SimpleInventory(5, 64){

        public void func_174889_b(PlayerEntity entityPlayer) {
            if (!entityPlayer.func_175149_v()) {
                super.func_174889_b(entityPlayer);
                TileUncolossalChest.this.triggerPlayerUsageChange(1);
            }
        }

        public void func_174886_c(PlayerEntity entityPlayer) {
            if (!entityPlayer.func_175149_v()) {
                super.func_174886_c(entityPlayer);
                TileUncolossalChest.this.triggerPlayerUsageChange(-1);
            }
        }
    };
    public float prevLidAngle;
    public float lidAngle;
    private int playersUsing;

    public TileUncolossalChest() {
        super(RegistryEntries.TILE_ENTITY_UNCOLOSSAL_CHEST);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> new InvWrapper((IInventory)this.inventory)));
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.inventory.read(tag.func_74775_l("inventory"));
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)tag.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT subTag = new CompoundNBT();
        this.inventory.write(subTag);
        tag.func_218657_a("inventory", (INBT)subTag);
        if (this.customName != null) {
            tag.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return super.func_189515_b(tag);
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.playersUsing != 0 && WorldHelpers.efficientTick((World)this.field_145850_b, (int)200, (int[])new int[]{this.func_174877_v().hashCode()})) {
            this.playersUsing = 0;
            float range = 5.0f;
            List entities = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v().func_177971_a(new Vec3i((double)(-range), (double)(-range), (double)(-range))), this.func_174877_v().func_177971_a(new Vec3i((double)(1.0f + range), (double)(1.0f + range), (double)(1.0f + range)))));
            for (PlayerEntity player : entities) {
                if (!(player.field_71070_bA instanceof ContainerColossalChest)) continue;
                ++this.playersUsing;
            }
            this.field_145850_b.func_175641_c(this.func_174877_v(), RegistryEntries.BLOCK_UNCOLOSSAL_CHEST, 1, this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        float increaseAngle = 0.25f;
        if (this.playersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.2f + 1.15f, false);
        }
        if (this.playersUsing == 0 && this.lidAngle > 0.0f || this.playersUsing > 0 && this.lidAngle < 1.0f) {
            float closedAngle;
            float preIncreaseAngle = this.lidAngle;
            this.lidAngle = this.playersUsing > 0 ? (this.lidAngle += increaseAngle) : (this.lidAngle -= increaseAngle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedAngle = 0.5f) && preIncreaseAngle >= closedAngle) {
                this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.2f + 1.15f, false);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.playersUsing = j;
        }
        return true;
    }

    private void triggerPlayerUsageChange(int change) {
        if (this.field_145850_b != null) {
            this.playersUsing += change;
            this.field_145850_b.func_175641_c(this.func_174877_v(), RegistryEntries.BLOCK_UNCOLOSSAL_CHEST, 1, this.playersUsing);
        }
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? this.customName : new TranslationTextComponent("general.colossalchests.uncolossalchest", new Object[0]);
    }

    public Direction getRotation() {
        if (this.func_145831_w() == null) {
            return Direction.SOUTH;
        }
        BlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() != RegistryEntries.BLOCK_UNCOLOSSAL_CHEST) {
            return Direction.NORTH;
        }
        return (Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (IProperty)UncolossalChest.FACING, (Comparable)Direction.NORTH);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerUncolossalChest(id, playerInventory, (IInventory)this.getInventory());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

