/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.colossalchests.Advancements;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.block.BlockTileGui;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;

public class ColossalChest
extends BlockTileGui
implements CubeDetector.IDetectionListener,
IBlockChestMaterial {
    public static final BooleanProperty ENABLED = BlockStateProperties.field_208180_g;
    private final ChestMaterial material;

    public ColossalChest(Block.Properties properties, ChestMaterial material) {
        super(properties, TileColossalChest::new);
        this.material = material;
        material.setBlockCore(this);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public String func_149739_a() {
        String baseKey = super.func_149739_a();
        return baseKey.substring(0, baseKey.lastIndexOf(95));
    }

    @Override
    public ChestMaterial getMaterial() {
        return this.material;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ENABLED});
    }

    public static boolean isToolEffectiveShared(ChestMaterial material, BlockState state, ToolType tool) {
        if (material == ChestMaterial.WOOD) {
            return tool == ToolType.AXE;
        }
        return tool == ToolType.PICKAXE;
    }

    public static boolean canPlace(IWorldReader world, BlockPos pos) {
        for (Direction side : Direction.values()) {
            BlockState blockState = world.func_180495_p(pos.func_177972_a(side));
            Block block = blockState.func_177230_c();
            if (!(block instanceof ColossalChest) && !(block instanceof ChestWall) && !(block instanceof Interface) || !blockState.func_206869_a().contains(ENABLED) || !((Boolean)blockState.func_177229_b((IProperty)ENABLED)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return ColossalChest.isToolEffectiveShared(this.material, state, tool);
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)ENABLED) != false ? BlockRenderType.ENTITYBLOCK_ANIMATED : super.func_149645_b(blockState);
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader blockReader, BlockPos blockPos) {
        return (Boolean)blockState.func_177229_b((IProperty)ENABLED);
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public boolean shouldDisplayFluidOverlay(BlockState blockState, ILightReader world, BlockPos pos, IFluidState fluidState) {
        return true;
    }

    public static DetectionResult triggerDetector(ChestMaterial material, IWorld world, BlockPos blockPos, boolean valid, @Nullable PlayerEntity player) {
        BlockState blockState;
        DetectionResult detectionResult = material.getChestDetector().detect((IWorldReader)world, blockPos, valid ? null : blockPos, (CubeDetector.IValidationAction)new MaterialValidationAction(), true);
        if (player instanceof ServerPlayerEntity && detectionResult.getError() == null && ((Boolean)(blockState = world.func_180495_p(blockPos)).func_177229_b((IProperty)ENABLED)).booleanValue()) {
            TileColossalChest tile = TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileColossalChest.class).orElse(null);
            if (tile == null) {
                BlockPos corePos = ColossalChest.getCoreLocation(material, (IWorldReader)world, blockPos);
                tile = TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)corePos, TileColossalChest.class).orElse(null);
            }
            Advancements.CHEST_FORMED.trigger((ServerPlayerEntity)player, Pair.of((Object)((Object)material), (Object)tile.getSizeSingular()));
        }
        return detectionResult;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileColossalChest tile;
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_82837_s() && (tile = (TileColossalChest)TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileColossalChest.class).orElse(null)) != null) {
            tile.setCustomName(stack.func_200301_q());
            tile.setSize(Vec3i.field_177959_e);
        }
        ColossalChest.triggerDetector(this.material, (IWorld)world, pos, true, placer instanceof PlayerEntity ? (PlayerEntity)placer : null);
    }

    public void func_220082_b(BlockState blockStateNew, World world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.func_220082_b(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.func_177230_c() != blockStateOld.func_177230_c() && !((Boolean)blockStateNew.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (IWorld)world, blockPos, true, null);
        }
    }

    public void onDetect(IWorldReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.func_180495_p(location).func_177230_c();
        if (block == this) {
            ((IWorldWriter)world).func_180501_a(location, (BlockState)world.func_180495_p(location).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(valid)), 2);
            TileColossalChest tile = TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)location, TileColossalChest.class).orElse(null);
            if (tile != null) {
                tile.setMaterial(this.material);
                tile.setSize(valid ? size : Vec3i.field_177959_e);
                tile.setCenter(new Vec3d((double)originCorner.func_177958_n() + (double)size.func_177958_n() / 2.0, (double)originCorner.func_177956_o() + (double)size.func_177956_o() / 2.0, (double)originCorner.func_177952_p() + (double)size.func_177952_p() / 2.0));
                tile.addInterface((Vec3i)location);
            }
        }
    }

    @Nullable
    public static BlockPos getCoreLocation(ChestMaterial material, IWorldReader world, BlockPos blockPos) {
        Wrapper tileLocationWrapper = new Wrapper();
        material.getChestDetector().detect(world, blockPos, null, (location, blockState) -> {
            if (blockState.func_177230_c() instanceof ColossalChest) {
                tileLocationWrapper.set((Object)location);
            }
            return null;
        }, false);
        return (BlockPos)tileLocationWrapper.get();
    }

    public static void addPlayerChatError(ChestMaterial material, World world, BlockPos blockPos, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K && player.func_184586_b(hand).func_190926_b()) {
            DetectionResult result = material.getChestDetector().detect((IWorldReader)world, blockPos, null, (CubeDetector.IValidationAction)new MaterialValidationAction(), false);
            if (result != null && result.getError() != null) {
                ColossalChest.addPlayerChatError(player, result.getError());
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("multiblock.colossalchests.error.unexpected", new Object[0]));
            }
        }
    }

    public static void addPlayerChatError(PlayerEntity player, ITextComponent error) {
        StringTextComponent chat = new StringTextComponent("");
        ITextComponent prefix = new StringTextComponent("[").func_150257_a((ITextComponent)new TranslationTextComponent("multiblock.colossalchests.error.prefix", new Object[0])).func_150257_a((ITextComponent)new StringTextComponent("]: ")).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("multiblock.colossalchests.error.prefix.info", new Object[0]))));
        chat.func_150257_a(prefix);
        chat.func_150257_a(error);
        player.func_145747_a((ITextComponent)chat);
    }

    public void writeExtraGuiData(PacketBuffer packetBuffer, World world, PlayerEntity player, BlockPos blockPos, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)blockPos, TileColossalChest.class).ifPresent(tile -> packetBuffer.writeInt(tile.getInventory().func_70302_i_()));
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (!((Boolean)blockState.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            ColossalChest.addPlayerChatError(this.material, world, blockPos, player, hand);
            return ActionResultType.FAIL;
        }
        return super.func_225533_a_(blockState, world, blockPos, player, hand, rayTraceResult);
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, world, blockPos, false, null);
        }
        super.func_176206_d(world, blockPos, blockState);
    }

    public void func_180652_a(World world, BlockPos blockPos, Explosion explosion) {
        if (((Boolean)world.func_180495_p(blockPos).func_177229_b((IProperty)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (IWorld)world, blockPos, false, null);
        }
        super.func_180652_a(world, blockPos, explosion);
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (this.material.isExplosionResistant()) {
            return 10000.0f;
        }
        return 0.0f;
    }

    public boolean func_196260_a(BlockState blockState, IWorldReader world, BlockPos blockPos) {
        return super.func_196260_a(blockState, world, blockPos) && ColossalChest.canPlace(world, blockPos);
    }

    private static class MaterialValidationAction
    implements CubeDetector.IValidationAction {
        private final Wrapper<ChestMaterial> requiredMaterial = new Wrapper(null);

        public ITextComponent onValidate(BlockPos blockPos, BlockState blockState) {
            ChestMaterial material = null;
            if (blockState.func_177230_c() instanceof IBlockChestMaterial) {
                material = ((IBlockChestMaterial)blockState.func_177230_c()).getMaterial();
            }
            if (this.requiredMaterial.get() == null) {
                this.requiredMaterial.set((Object)material);
                return null;
            }
            return this.requiredMaterial.get() == material ? null : new TranslationTextComponent("multiblock.colossalchests.error.material", new Object[]{new TranslationTextComponent(material.getUnlocalizedName(), new Object[0]), LocationHelpers.toCompactString((BlockPos)blockPos), new TranslationTextComponent(((ChestMaterial)((Object)this.requiredMaterial.get())).getUnlocalizedName(), new Object[0])});
        }
    }
}

