/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.element;

import java.util.List;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.blay09.mods.refinedrelocation.client.gui.RootFilterScreen;
import net.blay09.mods.refinedrelocation.client.gui.base.ITickableElement;
import net.blay09.mods.refinedrelocation.client.gui.base.ITooltipElement;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiImageButton;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiFilterSlot;
import net.blay09.mods.refinedrelocation.container.RootFilterContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TextFormatting;

public class GuiWhitelistButton
extends GuiImageButton
implements ITickableElement,
ITooltipElement {
    private final RootFilterScreen parentGui;
    private final GuiFilterSlot parentSlot;
    private boolean lastBlacklist;

    public GuiWhitelistButton(int x, int y, RootFilterScreen parentGui, GuiFilterSlot parentSlot) {
        super(x, y, 8, 8, GuiTextures.FILTER_WHITELIST, it -> {});
        this.parentGui = parentGui;
        this.parentSlot = parentSlot;
        this.visible = false;
    }

    @Override
    public void tick() {
        boolean nowBlacklist = ((RootFilterContainer)this.parentGui.func_212873_a_()).getRootFilter().isBlacklist(this.parentSlot.getFilterIndex());
        if (this.lastBlacklist != nowBlacklist) {
            this.setTexture(nowBlacklist ? GuiTextures.FILTER_BLACKLIST : GuiTextures.FILTER_WHITELIST);
            this.lastBlacklist = nowBlacklist;
        }
        this.visible = this.parentSlot.hasFilter();
    }

    public void onClick(double mouseX, double mouseY) {
        boolean isBlacklist = !((RootFilterContainer)this.parentGui.func_212873_a_()).getRootFilter().isBlacklist(this.parentSlot.getFilterIndex());
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_74768_a("FilterIndex", this.parentSlot.getFilterIndex());
        tagCompound.func_74757_a("Blacklist", isBlacklist);
        RefinedRelocationAPI.sendContainerMessageToServer("Blacklist", tagCompound);
        ((RootFilterContainer)this.parentGui.func_212873_a_()).getRootFilter().setIsBlacklist(this.parentSlot.getFilterIndex(), isBlacklist);
    }

    @Override
    public void addTooltip(List<String> list) {
        boolean nowBlacklist = ((RootFilterContainer)this.parentGui.func_212873_a_()).getRootFilter().isBlacklist(this.parentSlot.getFilterIndex());
        list.add(TextFormatting.WHITE + (nowBlacklist ? I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.blacklist", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.whitelist", (Object[])new Object[0])));
        list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.refinedrelocation:root_filter.click_to_toggle", (Object[])new Object[0]));
    }
}

