/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.base.element;

import com.mojang.blaze3d.systems.RenderSystem;
import net.blay09.mods.refinedrelocation.api.client.IDrawable;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.blay09.mods.refinedrelocation.client.gui.base.ITickableElement;
import net.blay09.mods.refinedrelocation.client.gui.base.element.IScrollTarget;
import net.minecraft.client.gui.widget.button.Button;

public class GuiScrollBar
extends Button
implements ITickableElement {
    private final IDrawable scrollbarTop;
    private final IDrawable scrollbarMiddle;
    private final IDrawable scrollbarBottom;
    private final IScrollTarget scrollTarget;
    private int barY;
    private int barHeight;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private double mouseClickY = -1.0;
    private int lastRowCount;
    private int lastVisibleRows;
    private int lastOffset;

    public GuiScrollBar(int x, int y, int height, IScrollTarget scrollTarget) {
        super(x, y, 7, height, "", it -> {});
        this.scrollTarget = scrollTarget;
        this.updateBarPosition();
        this.scrollbarTop = GuiTextures.SCROLLBAR_TOP;
        this.scrollbarMiddle = GuiTextures.SCROLLBAR_MIDDLE;
        this.scrollbarBottom = GuiTextures.SCROLLBAR_BOTTOM;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.forceMouseScrolled(delta);
            return true;
        }
        return false;
    }

    public void forceMouseScrolled(double delta) {
        this.setCurrentOffset(delta > 0.0 ? this.scrollTarget.getCurrentOffset() - 1 : this.scrollTarget.getCurrentOffset() + 1);
    }

    public void onRelease(double mouseX, double mouseY) {
        if (this.mouseClickY != -1.0) {
            this.mouseClickY = -1.0;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.getWidth()) && mouseY >= (double)this.barY && mouseY < (double)(this.barY + this.barHeight)) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.scrollTarget.getCurrentOffset();
        }
    }

    private void updateBarPosition() {
        this.barHeight = (int)((double)this.height * Math.min(1.0, (double)this.scrollTarget.getVisibleRows() / Math.ceil(this.scrollTarget.getRowCount())));
        this.barY = this.y + (this.height - this.barHeight) * this.scrollTarget.getCurrentOffset() / Math.max(1, (int)Math.ceil(this.scrollTarget.getRowCount()) - this.scrollTarget.getVisibleRows());
    }

    @Override
    public void tick() {
        if (this.lastRowCount != this.scrollTarget.getRowCount() || this.lastVisibleRows != this.scrollTarget.getVisibleRows() || this.lastOffset != this.scrollTarget.getCurrentOffset()) {
            this.updateBarPosition();
            this.lastRowCount = this.scrollTarget.getRowCount();
            this.lastVisibleRows = this.scrollTarget.getVisibleRows();
            this.lastOffset = this.scrollTarget.getCurrentOffset();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.mouseClickY != -1.0 && (pixelsPerFilter = (float)(this.height - this.barHeight) / (float)Math.max(1, (int)Math.ceil(this.scrollTarget.getRowCount()) - this.scrollTarget.getVisibleRows())) != 0.0f && (numberOfFiltersMoved = (int)(((double)mouseY - this.mouseClickY) / (double)pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.scrollbarTop.bind();
        this.scrollbarTop.draw(this.x - 2, this.y - 1, this.getBlitOffset());
        this.scrollbarBottom.draw(this.x - 2, this.y + this.height - 1, this.getBlitOffset());
        this.scrollbarMiddle.draw(this.x - 2, this.y + 2, 11.0, this.height - 3, this.getBlitOffset());
        GuiScrollBar.fill((int)this.x, (int)this.barY, (int)(this.x + this.getWidth()), (int)(this.barY + this.barHeight), (int)-5592406);
    }

    public void setCurrentOffset(int offset) {
        int currentOffset = Math.max(0, Math.min(offset, (int)(Math.ceil(this.scrollTarget.getRowCount()) - (double)this.scrollTarget.getVisibleRows())));
        this.scrollTarget.setCurrentOffset(currentOffset);
        this.updateBarPosition();
    }
}

