/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.logic.entityblocking.dreadlamp;

import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.logic.DistanceLogics;
import net.xalcon.torchmaster.common.logic.entityblocking.IEntityBlockingLight;

public class DreadLampEntityBlockingLight
implements IEntityBlockingLight {
    private BlockPos pos;

    public DreadLampEntityBlockingLight(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public boolean shouldBlockEntity(Entity entity) {
        return Torchmaster.DreadLampFilterRegistry.containsEntity(entity.func_200600_R().getRegistryName()) && DistanceLogics.Cubic.isPositionInRange(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U, this.pos, (Integer)TorchmasterConfig.GENERAL.dreadLampRadius.get());
    }

    @Override
    public String getLightSerializerKey() {
        return "dreadlamp";
    }

    @Override
    public boolean cleanupCheck(World world) {
        return world.func_175667_e(this.pos) && world.func_180495_p(this.pos).func_177230_c() != ModBlocks.blockMegaTorch;
    }

    @Override
    public String getName() {
        return "Mega Torch";
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }
}

