/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ExternalStorageNetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage.ItemExternalStorage;
import com.raoulvdberge.refinedstorage.inventory.item.BaseItemHandler;
import com.raoulvdberge.refinedstorage.inventory.item.ProxyItemHandler;
import com.raoulvdberge.refinedstorage.inventory.item.UpgradeItemHandler;
import com.raoulvdberge.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.raoulvdberge.refinedstorage.item.UpgradeItem;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class InterfaceNetworkNode
extends NetworkNode
implements IComparable {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "interface");
    private static final String NBT_COMPARE = "Compare";
    private BaseItemHandler importItems = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private BaseItemHandler exportFilterItems = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private BaseItemHandler exportItems = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private IItemHandler items = new ProxyItemHandler((IItemHandler)this.importItems, (IItemHandler)this.exportItems);
    private UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK, UpgradeItem.Type.CRAFTING).addListener(new NetworkNodeInventoryListener(this));
    private int compare = 1;
    private int currentSlot = 0;

    public InterfaceNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getInterface().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        ItemStack slot;
        super.update();
        if (!this.canUpdate()) {
            return;
        }
        if (this.currentSlot >= this.importItems.getSlots()) {
            this.currentSlot = 0;
        }
        if ((slot = this.importItems.getStackInSlot(this.currentSlot)).func_190926_b()) {
            ++this.currentSlot;
        } else if (this.ticks % this.upgrades.getSpeed() == 0) {
            int size = Math.min(slot.func_190916_E(), this.upgrades.getStackInteractCount());
            ItemStack remainder = this.network.insertItemTracked(slot, size);
            this.importItems.extractItem(this.currentSlot, size - remainder.func_190916_E(), false);
        }
        for (int i = 0; i < 9; ++i) {
            int delta;
            ItemStack wanted = this.exportFilterItems.getStackInSlot(i);
            ItemStack got = this.exportItems.getStackInSlot(i);
            if (wanted.func_190926_b()) {
                if (got.func_190926_b()) continue;
                this.exportItems.setStackInSlot(i, this.network.insertItemTracked(got, got.func_190916_E()));
                continue;
            }
            if (!got.func_190926_b() && !API.instance().getComparer().isEqual(wanted, got, this.getCompare())) {
                this.exportItems.setStackInSlot(i, this.network.insertItemTracked(got, got.func_190916_E()));
                continue;
            }
            int n = delta = got.func_190926_b() ? wanted.func_190916_E() : wanted.func_190916_E() - got.func_190916_E();
            if (delta > 0) {
                boolean actingAsStorage = this.isActingAsStorage();
                ItemStack result = this.network.extractItem(wanted, delta, this.compare, Action.PERFORM, s -> {
                    if (!actingAsStorage) {
                        return true;
                    }
                    return !(s instanceof ItemExternalStorage) || !((ItemExternalStorage)s).isConnectedToInterface();
                });
                if (!result.func_190926_b()) {
                    if (this.exportItems.getStackInSlot(i).func_190926_b()) {
                        this.exportItems.setStackInSlot(i, result);
                    } else {
                        this.exportItems.getStackInSlot(i).func_190917_f(result.func_190916_E());
                    }
                }
                if ((delta -= result.func_190916_E()) <= 0 || !this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) continue;
                this.network.getCraftingManager().request((Object)new SlottedCraftingRequest(this, i), wanted, delta);
                continue;
            }
            if (delta >= 0) continue;
            ItemStack remainder = this.network.insertItemTracked(got, Math.abs(delta));
            this.exportItems.extractItem(i, Math.abs(delta) - remainder.func_190916_E(), false);
        }
    }

    private boolean isActingAsStorage() {
        for (Direction facing : Direction.values()) {
            INetworkNode facingNode = API.instance().getNetworkNodeManager((ServerWorld)this.world).getNode(this.pos.func_177972_a(facing));
            if (!(facingNode instanceof ExternalStorageNetworkNode) || !facingNode.isActive() || ((ExternalStorageNetworkNode)facingNode).getDirection() != facing.func_176734_d() || ((ExternalStorageNetworkNode)facingNode).getType() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.importItems, 0, tag);
        StackUtils.readItems(this.exportItems, 2, tag);
        StackUtils.readItems(this.upgrades, 3, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.importItems, 0, tag);
        StackUtils.writeItems((IItemHandler)this.exportItems, 2, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 3, tag);
        return tag;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.exportFilterItems, 1, tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        StackUtils.readItems(this.exportFilterItems, 1, tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
    }

    public IItemHandler getImportItems() {
        return this.importItems;
    }

    public IItemHandler getExportFilterItems() {
        return this.exportFilterItems;
    }

    public IItemHandler getExportItems() {
        return this.exportItems;
    }

    public IItemHandler getItems() {
        return this.items;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.importItems, this.exportItems, this.upgrades});
    }
}

