/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import de.ellpeck.naturesaura.recipes.OfferingRecipe;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityOfferingTable
extends TileEntityImpl
implements ITickableTileEntity {
    public final ItemStackHandler items = new ItemStackHandlerNA(1, this, true){

        public int getSlotLimit(int slot) {
            return 16;
        }
    };
    private final Queue<ItemStack> itemsToSpawn = new ArrayDeque<ItemStack>();

    public TileEntityOfferingTable() {
        super(ModTileEntities.OFFERING_TABLE);
    }

    private OfferingRecipe getRecipe(ItemStack input) {
        for (OfferingRecipe recipe : this.field_145850_b.func_199532_z().func_215370_b(ModRecipes.OFFERING_TYPE, null, null)) {
            if (!recipe.input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                if (!Multiblocks.OFFERING_TABLE.isComplete(this.field_145850_b, this.field_174879_c)) {
                    return;
                }
                ItemStack stack = this.items.getStackInSlot(0);
                if (stack.func_190926_b()) {
                    return;
                }
                List items = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(1.0));
                if (items.isEmpty()) {
                    return;
                }
                OfferingRecipe recipe = this.getRecipe(stack);
                if (recipe == null) {
                    return;
                }
                for (ItemEntity item : items) {
                    ItemStack itemStack;
                    if (!item.func_70089_S() || item.func_174874_s() || (itemStack = item.func_92059_d()).func_190926_b() || itemStack.func_190916_E() != 1 || !recipe.startItem.test(itemStack)) continue;
                    int amount = Helper.getIngredientAmount(recipe.input);
                    int recipeCount = stack.func_190916_E() / amount;
                    stack.func_190918_g(recipeCount * amount);
                    item.func_70106_y();
                    this.sendToClients();
                    for (int i = 0; i < recipeCount; ++i) {
                        this.itemsToSpawn.add(recipe.output.func_77946_l());
                    }
                    ((ServerWorld)this.field_145850_b).func_217468_a(new LightningBoltEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), true));
                    PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticles((float)item.func_226277_ct_(), (float)item.func_226278_cu_(), (float)item.func_226281_cx_(), PacketParticles.Type.OFFERING_TABLE, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
                    break;
                }
            } else if (this.field_145850_b.func_82737_E() % 3L == 0L && !this.itemsToSpawn.isEmpty()) {
                this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), 256.0, (double)((float)this.field_174879_c.func_177952_p() + 0.5f), this.itemsToSpawn.remove()));
            }
        }
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            compound.func_218657_a("items", (INBT)this.items.serializeNBT());
            if (type != TileEntityImpl.SaveType.SYNC) {
                ListNBT list = new ListNBT();
                for (ItemStack stack : this.itemsToSpawn) {
                    list.add((Object)stack.serializeNBT());
                }
                compound.func_218657_a("items_to_spawn", (INBT)list);
            }
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.items.deserializeNBT(compound.func_74775_l("items"));
            if (type != TileEntityImpl.SaveType.SYNC) {
                this.itemsToSpawn.clear();
                ListNBT list = compound.func_150295_c("items_to_spawn", 10);
                for (INBT base : list) {
                    this.itemsToSpawn.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)base)));
                }
            }
        }
    }

    @Override
    public IItemHandlerModifiable getItemHandler(Direction facing) {
        return this.items;
    }
}

