/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.features;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.blocks.HoneycombBrood;

public class HoneycombHole
extends Feature<NoFeatureConfig> {
    private static final int[][] bodyLayout = new int[][]{{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 3, 3, 3, 3, 1, 0, 0, 0}, {0, 0, 1, 3, 3, 3, 3, 3, 3, 1, 0, 0}, {0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 1, 0}, {1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1}, {1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1}, {0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 1, 0}, {0, 0, 1, 3, 3, 3, 3, 3, 3, 1, 0, 0}, {0, 0, 0, 1, 3, 3, 3, 3, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}};
    private static final int[][] largeHoneyLayout = new int[][]{{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 2, 2, 1, 1, 0, 0, 0}, {0, 0, 1, 1, 2, 2, 2, 2, 1, 1, 0, 0}, {0, 1, 1, 2, 2, 3, 3, 2, 2, 1, 1, 0}, {1, 1, 2, 2, 3, 3, 3, 3, 2, 2, 1, 1}, {1, 1, 2, 2, 3, 3, 3, 3, 2, 2, 1, 1}, {0, 1, 1, 2, 2, 3, 3, 2, 2, 1, 1, 0}, {0, 0, 1, 1, 2, 2, 2, 2, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 2, 2, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}};
    private static final int[][] smallHoneyLayout = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 2, 2, 1, 1, 0, 0, 0}, {0, 0, 1, 1, 2, 5, 5, 2, 1, 1, 0, 0}, {0, 0, 1, 1, 2, 5, 5, 2, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 2, 2, 1, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private static final int[][] endCapLayout = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private static final BlockState FILLED_POROUS_HONEYCOMB = ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).func_176223_P();
    private static final BlockState HONEY_BLOCK = Blocks.field_226907_mc_.func_176223_P();
    private static final BlockState HONEYCOMB_BLOCK = Blocks.field_226908_md_.func_176223_P();
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState SUGAR_WATER = ((FlowingFluidBlock)BzBlocks.SUGAR_WATER_BLOCK.get()).func_176223_P();

    public HoneycombHole(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig config) {
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable(position);
        this.generateSlice(world, mutableBlockPos, endCapLayout, rand, true);
        this.generateSlice(world, mutableBlockPos.func_189536_c(Direction.EAST), smallHoneyLayout, rand, true);
        this.generateSlice(world, mutableBlockPos.func_189536_c(Direction.EAST), largeHoneyLayout, rand, true);
        this.generateSlice(world, mutableBlockPos.func_189536_c(Direction.EAST), bodyLayout, rand, true);
        this.generateSlice(world, mutableBlockPos.func_189536_c(Direction.EAST), bodyLayout, rand, true);
        this.generateSlice(world, mutableBlockPos.func_189536_c(Direction.EAST), bodyLayout, rand, false);
        this.generateSlice(world, mutableBlockPos.func_189536_c(Direction.EAST), bodyLayout, rand, false);
        this.generateSlice(world, mutableBlockPos.func_189536_c(Direction.EAST), bodyLayout, rand, false);
        this.generateSlice(world, mutableBlockPos.func_189536_c(Direction.EAST), largeHoneyLayout, rand, false);
        this.generateSlice(world, mutableBlockPos.func_189536_c(Direction.EAST), smallHoneyLayout, rand, false);
        this.generateSlice(world, mutableBlockPos.func_189536_c(Direction.EAST), endCapLayout, rand, false);
        return true;
    }

    private void generateSlice(IWorld world, BlockPos.Mutable centerPos, int[][] slice, Random rand, boolean westEnd) {
        BlockPos.Mutable currentPosition = new BlockPos.Mutable(centerPos.func_177982_a(-5, slice.length / 2, -slice[0].length / 2));
        for (int y = 0; y < slice.length; ++y) {
            for (int z = 0; z < slice[0].length; ++z) {
                int sliceBlock;
                BlockState blockState = world.func_180495_p((BlockPos)currentPosition);
                if (world.func_180495_p((BlockPos)currentPosition).func_185904_a() != Material.field_151579_a && blockState.func_204520_s().func_206888_e() && (sliceBlock = slice[y][z]) != 0) {
                    if (sliceBlock == 1) {
                        if (world.func_180495_p(currentPosition.func_177976_e()).func_200132_m() && world.func_180495_p(currentPosition.func_177974_f()).func_200132_m()) {
                            if (rand.nextInt(3) == 0) {
                                world.func_180501_a((BlockPos)currentPosition, HONEYCOMB_BLOCK, 2);
                            } else {
                                world.func_180501_a((BlockPos)currentPosition, FILLED_POROUS_HONEYCOMB, 2);
                            }
                        }
                    } else if (sliceBlock == 2) {
                        if (rand.nextInt(3) == 0) {
                            world.func_180501_a((BlockPos)currentPosition, FILLED_POROUS_HONEYCOMB, 2);
                        } else {
                            world.func_180501_a((BlockPos)currentPosition, HONEY_BLOCK, 2);
                        }
                    } else if (sliceBlock == 3) {
                        if (currentPosition.func_177956_o() >= world.func_181545_F()) {
                            world.func_180501_a((BlockPos)currentPosition, CAVE_AIR, 2);
                        } else {
                            world.func_180501_a((BlockPos)currentPosition, SUGAR_WATER, 2);
                        }
                    } else if (sliceBlock == 5) {
                        int chance = rand.nextInt(10);
                        if (chance <= 3) {
                            Direction facing = westEnd ? Direction.WEST : Direction.EAST;
                            if (rand.nextFloat() < 0.8f) {
                                world.func_180501_a((BlockPos)currentPosition, (BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_LARVA.get()).func_176223_P().func_206870_a((IProperty)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(rand.nextInt(3)))).func_206870_a((IProperty)HoneycombBrood.field_176387_N, (Comparable)facing), 2);
                            } else {
                                world.func_180501_a((BlockPos)currentPosition, (BlockState)((Block)BzBlocks.DEAD_HONEYCOMB_LARVA.get()).func_176223_P().func_206870_a((IProperty)HoneycombBrood.field_176387_N, (Comparable)facing), 2);
                            }
                        } else if (chance <= 6) {
                            world.func_180501_a((BlockPos)currentPosition, FILLED_POROUS_HONEYCOMB, 2);
                        } else {
                            world.func_180501_a((BlockPos)currentPosition, HONEY_BLOCK, 2);
                        }
                    }
                }
                currentPosition.func_189536_c(Direction.SOUTH);
            }
            currentPosition.func_196234_d(0, -1, -slice[0].length);
        }
    }
}

