/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.dimension.BzDimensionRegistration;
import net.telepathicgrunt.bumblezone.effects.BzEffects;
import net.telepathicgrunt.bumblezone.items.BzItems;
import net.telepathicgrunt.bumblezone.items.HoneyBottleDispenseBehavior;
import net.telepathicgrunt.bumblezone.modcompatibility.BuzzierBeesRedirection;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;

public class HoneycombBrood
extends DirectionalBlock {
    public static final IntegerProperty STAGE = BlockStateProperties.field_208168_U;
    private static final DefaultDispenseItemBehavior BEHAVIOUR_DEFAULT_DISPENSE_ITEM = new HoneyBottleDispenseBehavior();
    private static final EntityPredicate FIXED_DISTANCE = new EntityPredicate().func_221013_a(50.0);
    private static final EntityPredicate PLAYER_DISTANCE = new EntityPredicate();

    public HoneycombBrood() {
        super(Block.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_151676_q).func_200944_c().func_200943_b(0.5f).func_226897_b_(0.9f).func_200947_a(SoundType.field_211383_n));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176387_N, (Comparable)Direction.SOUTH)).func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        DispenserBlock.func_199774_a((IItemProvider)Items.field_226638_pX_, (IDispenseItemBehavior)BEHAVIOUR_DEFAULT_DISPENSE_ITEM);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176387_N, STAGE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)context.func_196000_l().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)field_176387_N)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)field_176387_N)));
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        double yMagnitude = Math.abs(entityIn.func_213322_ci().field_72448_b);
        if (yMagnitude < 0.1) {
            double slowFactor = 0.85;
            entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(slowFactor, 1.0, slowFactor));
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public ActionResultType func_225533_a_(BlockState thisBlockState, World world, BlockPos position, PlayerEntity playerEntity, Hand playerHand, BlockRayTraceResult raytraceResult) {
        ItemStack itemstack = playerEntity.func_184586_b(playerHand);
        if (itemstack.func_77973_b() == Items.field_151069_bo) {
            world.func_180501_a(position, (BlockState)((Block)BzBlocks.DEAD_HONEYCOMB_LARVA.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, thisBlockState.func_177229_b((IProperty)BlockStateProperties.field_208155_H)), 3);
            int stage = (Integer)thisBlockState.func_177229_b((IProperty)STAGE);
            HoneycombBrood.spawnBee(world, thisBlockState, position, stage);
            world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (!playerEntity.func_184812_l_()) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)Items.field_226638_pX_));
                } else if (!playerEntity.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_226638_pX_))) {
                    playerEntity.func_71019_a(new ItemStack((IItemProvider)Items.field_226638_pX_), false);
                }
            }
            if ((playerEntity.field_71093_bK == BzDimensionRegistration.bumblezone() || Bumblezone.BzConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && !playerEntity.func_184812_l_() && !playerEntity.func_175149_v() && Bumblezone.BzConfig.aggressiveBees.get().booleanValue()) {
                playerEntity.func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
            }
            return ActionResultType.SUCCESS;
        }
        if (itemstack.func_77973_b() == Items.field_226638_pX_ || itemstack.func_77973_b() == BzItems.SUGAR_WATER_BOTTLE.get()) {
            if (!world.field_72995_K) {
                boolean successfulGrowth = false;
                if (itemstack.func_77973_b() == BzItems.SUGAR_WATER_BOTTLE.get()) {
                    if (world.field_73012_v.nextFloat() < 0.3f) {
                        successfulGrowth = true;
                    }
                } else {
                    successfulGrowth = true;
                }
                if (successfulGrowth) {
                    int stage = (Integer)thisBlockState.func_177229_b((IProperty)STAGE);
                    if (stage == 3) {
                        HoneycombBrood.spawnBee(world, thisBlockState, position, stage);
                    } else {
                        world.func_175656_a(position, (BlockState)thisBlockState.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage + 1)));
                    }
                }
            }
            world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_191241_J, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (!playerEntity.func_184812_l_()) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    playerEntity.func_184611_a(playerHand, new ItemStack((IItemProvider)Items.field_151069_bo));
                } else if (!playerEntity.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151069_bo))) {
                    playerEntity.func_71019_a(new ItemStack((IItemProvider)Items.field_151069_bo), false);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (ModChecking.buzzierBeesPresent && Bumblezone.BzConfig.allowHoneyWandCompat.get().booleanValue()) {
            ActionResultType action = BuzzierBeesRedirection.honeyWandTakingHoney(itemstack, thisBlockState, world, position, playerEntity, playerHand);
            if (action == ActionResultType.SUCCESS) {
                world.func_180501_a(position, (BlockState)((Block)BzBlocks.DEAD_HONEYCOMB_LARVA.get()).func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, thisBlockState.func_177229_b((IProperty)BlockStateProperties.field_208155_H)), 3);
                int stage = (Integer)thisBlockState.func_177229_b((IProperty)STAGE);
                HoneycombBrood.spawnBee(world, thisBlockState, position, stage);
                world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_226135_eP_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if ((playerEntity.field_71093_bK == BzDimensionRegistration.bumblezone() || Bumblezone.BzConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && !playerEntity.func_184812_l_() && !playerEntity.func_175149_v() && Bumblezone.BzConfig.aggressiveBees.get().booleanValue()) {
                    playerEntity.func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
                }
                return action;
            }
            action = BuzzierBeesRedirection.honeyWandGivingHoney(itemstack, thisBlockState, world, position, playerEntity, playerHand);
            if (action == ActionResultType.SUCCESS) {
                world.func_184148_a(playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_226135_eP_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                int stage = (Integer)thisBlockState.func_177229_b((IProperty)STAGE);
                if (stage == 3) {
                    HoneycombBrood.spawnBee(world, thisBlockState, position, stage);
                } else {
                    world.func_175656_a(position, (BlockState)thisBlockState.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage + 1)));
                }
                return action;
            }
        }
        return super.func_225533_a_(thisBlockState, world, position, playerEntity, playerHand, raytraceResult);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos position, Random rand) {
        super.func_225534_a_(state, world, position, rand);
        if (!world.isAreaLoaded(position, 1)) {
            return;
        }
        int stage = (Integer)state.func_177229_b((IProperty)STAGE);
        if (stage < 3) {
            if (world.func_201675_m().func_186058_p() == BzDimensionRegistration.bumblezone() ? rand.nextInt(10) == 0 : rand.nextInt(22) == 0) {
                world.func_180501_a(position, (BlockState)state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage + 1)), 2);
            }
        } else {
            PLAYER_DISTANCE.func_221013_a(Math.max((double)Bumblezone.BzConfig.aggressionTriggerRadius.get().intValue() * 0.5, 1.0));
            List beeList = world.func_217374_a(BeeEntity.class, FIXED_DISTANCE, null, new AxisAlignedBB(position).func_186662_g(50.0));
            List playerList = world.func_217374_a(PlayerEntity.class, PLAYER_DISTANCE, null, new AxisAlignedBB(position).func_186662_g(50.0));
            if (beeList.size() < 10 || playerList.stream().anyMatch(player -> player.func_70644_a(BzEffects.WRATH_OF_THE_HIVE))) {
                HoneycombBrood.spawnBee((World)world, state, position, stage);
            }
        }
    }

    public void func_176208_a(World world, BlockPos position, BlockState state, PlayerEntity playerEntity) {
        ListNBT listOfEnchants;
        Hand hand = playerEntity.field_184622_au;
        if (hand != null && !(listOfEnchants = playerEntity.func_184586_b(hand).func_77986_q()).stream().anyMatch(enchant -> enchant.func_150285_a_().contains("minecraft:silk_touch"))) {
            BlockState blockState = world.func_180495_p(position);
            int stage = (Integer)blockState.func_177229_b((IProperty)STAGE);
            if (stage == 3) {
                HoneycombBrood.spawnBee(world, blockState, position, stage);
            }
            if ((playerEntity.field_71093_bK == BzDimensionRegistration.bumblezone() || Bumblezone.BzConfig.allowWrathOfTheHiveOutsideBumblezone.get().booleanValue()) && !playerEntity.func_184812_l_() && !playerEntity.func_175149_v() && Bumblezone.BzConfig.aggressiveBees.get().booleanValue()) {
                playerEntity.func_195064_c(new EffectInstance(BzEffects.WRATH_OF_THE_HIVE, Bumblezone.BzConfig.howLongWrathOfTheHiveLasts.get().intValue(), 2, false, Bumblezone.BzConfig.showWrathOfTheHiveParticles.get().booleanValue(), true));
            }
        }
        super.func_176208_a(world, position, state, playerEntity);
    }

    private static boolean spawnBee(World world, BlockState state, BlockPos position, int stage) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable(position);
        blockpos.func_189536_c(((Direction)state.func_177229_b((IProperty)field_176387_N)).func_176734_d());
        if (stage == 3 && !world.func_180495_p((BlockPos)blockpos).func_185904_a().func_76220_a()) {
            MobEntity beeEntity = (MobEntity)EntityType.field_226289_e_.func_200721_a(world);
            beeEntity.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, world.func_201674_k().nextFloat() * 360.0f, 0.0f);
            if (ForgeHooks.canEntitySpawn((MobEntity)beeEntity, (IWorld)world, (double)((double)blockpos.func_177958_n() + 0.5), (double)((double)blockpos.func_177956_o() + 0.5), (double)((double)blockpos.func_177952_p() + 0.5), null, (SpawnReason)SpawnReason.TRIGGERED) != -1) {
                ILivingEntityData ilivingentitydata = null;
                ilivingentitydata = beeEntity.func_213386_a((IWorld)world, world.func_175649_E(new BlockPos((Entity)beeEntity)), SpawnReason.TRIGGERED, ilivingentitydata, (CompoundNBT)null);
                world.func_217376_c((Entity)beeEntity);
                world.func_175656_a(position, (BlockState)state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
                return true;
            }
        }
        return false;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((IProperty)STAGE) + 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState blockState, World world, BlockPos position, Random random) {
        for (int i = 0; i < random.nextInt(2); ++i) {
            this.spawnHoneyParticles(world, position, blockState);
        }
        int stage = (Integer)blockState.func_177229_b((IProperty)STAGE);
        float soundVolume = 0.1f + (float)stage * 0.3f;
        world.func_184134_a((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), SoundEvents.field_226127_ab_, SoundCategory.PLAYERS, soundVolume, 1.0f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnHoneyParticles(World world, BlockPos position, BlockState blockState) {
        VoxelShape currentBlockShape;
        double yEndHeight;
        if (blockState.func_204520_s().func_206888_e() && world.field_73012_v.nextFloat() < 0.08f && (yEndHeight = (currentBlockShape = blockState.func_196952_d((IBlockReader)world, position)).func_197758_c(Direction.Axis.Y)) >= 1.0 && !blockState.func_203425_a(BlockTags.field_211923_H)) {
            double yStartHeight = currentBlockShape.func_197762_b(Direction.Axis.Y);
            if (yStartHeight > 0.0) {
                this.addHoneyParticle(world, position, currentBlockShape, (double)position.func_177956_o() + yStartHeight - 0.05);
            } else {
                BlockPos belowBlockpos = position.func_177977_b();
                BlockState belowBlockstate = world.func_180495_p(belowBlockpos);
                VoxelShape belowBlockShape = belowBlockstate.func_196952_d((IBlockReader)world, belowBlockpos);
                double yEndHeight2 = belowBlockShape.func_197758_c(Direction.Axis.Y);
                if ((yEndHeight2 < 1.0 || !belowBlockstate.func_215686_e((IBlockReader)world, belowBlockpos)) && belowBlockstate.func_204520_s().func_206888_e()) {
                    this.addHoneyParticle(world, position, currentBlockShape, (double)position.func_177956_o() - 0.05);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addHoneyParticle(World world, BlockPos blockPos, VoxelShape blockShape, double height) {
        this.addHoneyParticle(world, (double)blockPos.func_177958_n() + blockShape.func_197762_b(Direction.Axis.X), (double)blockPos.func_177958_n() + blockShape.func_197758_c(Direction.Axis.X), (double)blockPos.func_177952_p() + blockShape.func_197762_b(Direction.Axis.Z), (double)blockPos.func_177952_p() + blockShape.func_197758_c(Direction.Axis.Z), height);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addHoneyParticle(World world, double xMin, double xMax, double zMax, double zMin, double yHeight) {
        world.func_195594_a((IParticleData)ParticleTypes.field_229427_ag_, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)xMin, (double)xMax), yHeight, MathHelper.func_219803_d((double)world.field_73012_v.nextDouble(), (double)zMax, (double)zMin), 0.0, 0.0, 0.0);
    }
}

