/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl.map;

import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.dimension.DimensionType;

public class XZ {
    public final int x;
    public final int z;

    public static XZ of(int x, int z) {
        return new XZ(x, z);
    }

    public static XZ of(ChunkPos pos) {
        return XZ.of(pos.field_77276_a, pos.field_77275_b);
    }

    public static XZ chunkFromBlock(int x, int z) {
        return XZ.of(x >> 4, z >> 4);
    }

    public static XZ chunkFromBlock(Vec3i pos) {
        return XZ.chunkFromBlock(pos.func_177958_n(), pos.func_177952_p());
    }

    public static XZ regionFromChunk(int x, int z) {
        return XZ.of(x >> 5, z >> 5);
    }

    public static XZ regionFromBlock(int x, int z) {
        return XZ.of(x >> 9, z >> 9);
    }

    private XZ(int _x, int _z) {
        this.x = _x;
        this.z = _z;
    }

    public int hashCode() {
        int x1 = 1664525 * this.x + 1013904223;
        int z1 = 1664525 * (this.z ^ 0xDEADBEEF) + 1013904223;
        return x1 ^ z1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XZ)) {
            return false;
        }
        XZ p = (XZ)o;
        return this.x == p.x && this.z == p.z;
    }

    public String toString() {
        return "[" + this.x + ", " + this.z + "]";
    }

    public ChunkDimPos dim(DimensionType type) {
        return new ChunkDimPos(type, this.x, this.z);
    }

    public XZ offset(int ox, int oz) {
        return XZ.of(this.x + ox, this.z + oz);
    }
}

