/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommandSuicide {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        if (ConfigValues.suicide_enable_player.booleanValue()) {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"suicide").requires(source -> source.func_197034_c(0));
            builder.executes(context -> CommandSuicide.suicide((CommandContext<CommandSource>)context));
            dispatcher.register(builder);
        }
        LiteralArgumentBuilder builder2 = (LiteralArgumentBuilder)Commands.func_197057_a((String)"suicide").requires(source -> source.func_197034_c(2));
        builder2.then(Commands.func_197056_a((String)"targetPlayer", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> CommandSuicide.suicideArgs((CommandContext<CommandSource>)context)));
        dispatcher.register(builder2);
    }

    private static int suicide(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        long cooldown = eslPlayer.getUsage().getCommandCooldown("suicide", ConfigValues.suicide_player_cooldown.intValue());
        if (cooldown != 0L) {
            player.func_145747_a((ITextComponent)Methods.formatText("maessentials.cooldown", cooldown));
            return 1;
        }
        eslPlayer.getUsage().setCommandUsage("suicide");
        eslPlayer.saveData();
        CommandSuicide.doSuicide(player, player);
        return 1;
    }

    private static int suicideArgs(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ServerPlayerEntity targetPlayer = EntityArgument.func_197089_d(context, (String)"targetPlayer");
        CommandSuicide.doSuicide(player, targetPlayer);
        return 1;
    }

    private static void doSuicide(ServerPlayerEntity player, ServerPlayerEntity target) {
        if (target.field_71134_c.func_73081_b() == GameType.CREATIVE || target.field_71134_c.func_73081_b() == GameType.SPECTATOR) {
            if (player == target) {
                target.func_145747_a((ITextComponent)Methods.formatText("maessentials.invaild_gamemode", new Object[0]));
            } else {
                target.func_145747_a((ITextComponent)Methods.formatText("maessentials.invaild_gamemode.player", target.func_145748_c_()));
            }
            return;
        }
        target.func_70097_a(DamageSource.field_180137_b, target.func_110143_aJ());
        ServerWorld world = (ServerWorld)player.field_70170_p;
        LightningBoltEntity entity = new LightningBoltEntity((World)world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), true);
        world.func_217468_a(entity);
        if (player != target) {
            player.func_145747_a((ITextComponent)Methods.formatText("suicide.maessentials.player", target.func_145748_c_()));
            target.func_145747_a((ITextComponent)Methods.formatText("suicide.maessentials.player.target", player.func_145748_c_()));
        }
    }
}

