/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.BitSet;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;

public class UpdateConfigMessage {
    private BitSet boolConfigs;
    private int[] intConfigs;

    public UpdateConfigMessage(BitSet boolConfigs, int[] intConfigs) {
        this.boolConfigs = boolConfigs;
        this.intConfigs = intConfigs;
    }

    static UpdateConfigMessage fromBytes(PacketBuffer buf) {
        return new UpdateConfigMessage(BitSet.valueOf(buf.func_179251_a()), buf.func_186863_b());
    }

    static void toBytes(UpdateConfigMessage msg, PacketBuffer buf) {
        buf.func_179250_a(msg.boolConfigs.toByteArray());
        buf.func_186875_a(msg.intConfigs);
    }

    public static class Handler {
        static void handle(UpdateConfigMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> SharedConfigTombstone.updateConfig(message.boolConfigs, message.intConfigs));
            }
            ctx.setPacketHandled(true);
        }
    }
}

