/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.perk.PerkRegistry;

public class SyncCapClientMessage {
    private SyncType syncType;
    private long knowledge;
    private HashMap<Perk, Integer> perks;
    private Perk perk;
    private int level;
    private int alignment;

    public SyncCapClientMessage(SyncType syncType, Object ... params) {
        this.syncType = syncType;
        if (syncType == SyncType.ALL) {
            this.knowledge = params.length > 0 ? (Long)params[0] : 0L;
            this.alignment = params.length > 1 ? (Integer)params[1] : 0;
            this.perks = params.length > 2 ? (HashMap)params[2] : new HashMap();
        } else if (syncType == SyncType.KNOWLEDGE) {
            this.knowledge = params.length > 0 ? (Long)params[0] : 0L;
        } else if (syncType == SyncType.ALIGNMENT) {
            this.alignment = params.length > 0 ? (Integer)params[0] : 0;
        } else if (syncType == SyncType.PERKS) {
            this.perks = params.length > 0 ? (HashMap)params[0] : new HashMap();
        } else if (syncType == SyncType.SET_PERK) {
            this.perk = params.length > 0 ? (Perk)params[0] : null;
            this.level = params.length > 1 ? (Integer)params[1] : 1;
        } else if (syncType == SyncType.REMOVE_PERK) {
            this.perk = params.length > 0 ? (Perk)params[0] : null;
        }
    }

    static SyncCapClientMessage fromBytes(PacketBuffer buf) {
        SyncType syncType = SyncType.values()[buf.readShort()];
        switch (syncType) {
            case KNOWLEDGE: {
                return new SyncCapClientMessage(syncType, buf.readLong());
            }
            case ALIGNMENT: {
                return new SyncCapClientMessage(syncType, buf.readInt());
            }
            case ALL: {
                return new SyncCapClientMessage(syncType, buf.readLong(), buf.readInt(), SyncCapClientMessage.readPerks(buf.func_150793_b()));
            }
            case PERKS: {
                return new SyncCapClientMessage(syncType, SyncCapClientMessage.readPerks(buf.func_150793_b()));
            }
            case SET_PERK: {
                return new SyncCapClientMessage(syncType, PerkRegistry.perkRegistry.getValue(buf.readInt()), buf.readInt());
            }
            case REMOVE_PERK: {
                return new SyncCapClientMessage(syncType, PerkRegistry.perkRegistry.getValue(buf.readInt()));
            }
        }
        return new SyncCapClientMessage(syncType, buf.readLong(), buf.readLong());
    }

    private static HashMap<Perk, Integer> readPerks(CompoundNBT tag) {
        HashMap<Perk, Integer> perks = new HashMap<Perk, Integer>();
        if (tag != null && tag.func_150297_b("perks", 9)) {
            ListNBT tagPerks = tag.func_150295_c("perks", 10);
            for (int i = 0; i < tagPerks.size(); ++i) {
                Perk perk;
                CompoundNBT tagPerk = tagPerks.func_150305_b(i);
                if (!tagPerk.func_150297_b("id", 3) || !tagPerk.func_150297_b("level", 3) || (perk = (Perk)PerkRegistry.perkRegistry.getValue(tagPerk.func_74762_e("id"))) == null) continue;
                perks.put(perk, tagPerk.func_74762_e("level"));
            }
        }
        return perks;
    }

    static void toBytes(SyncCapClientMessage msg, PacketBuffer buf) {
        boolean isSyncAll;
        buf.writeShort(msg.syncType.ordinal());
        boolean bl = isSyncAll = msg.syncType == SyncType.ALL;
        if (isSyncAll || msg.syncType == SyncType.KNOWLEDGE) {
            buf.writeLong(msg.knowledge);
        }
        if (isSyncAll || msg.syncType == SyncType.ALIGNMENT) {
            buf.writeInt(msg.alignment);
        }
        if (isSyncAll || msg.syncType == SyncType.PERKS) {
            CompoundNBT tag = new CompoundNBT();
            ListNBT tagPerks = new ListNBT();
            for (Map.Entry<Perk, Integer> entry : msg.perks.entrySet()) {
                CompoundNBT tagPerk = new CompoundNBT();
                tagPerk.func_74768_a("id", PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)entry.getKey()));
                tagPerk.func_74768_a("level", entry.getValue().intValue());
                tagPerks.add((Object)tagPerk);
            }
            tag.func_218657_a("perks", (INBT)tagPerks);
            buf.func_150786_a(tag);
        }
        if (msg.syncType == SyncType.SET_PERK) {
            buf.writeInt(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)msg.perk));
            buf.writeInt(msg.level);
        }
        if (msg.syncType == SyncType.REMOVE_PERK) {
            buf.writeInt(PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)msg.perk));
        }
    }

    public static class Handler {
        static void handle(final SyncCapClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                        if (player != null) {
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null).ifPresent(cap -> {
                                switch (message.syncType) {
                                    case ALL: {
                                        cap.setKnowledge(message.knowledge);
                                        cap.setAlignment(message.alignment);
                                        cap.setPerks(message.perks);
                                        break;
                                    }
                                    case KNOWLEDGE: {
                                        cap.setKnowledge(message.knowledge);
                                        break;
                                    }
                                    case PERKS: {
                                        cap.setPerks(message.perks);
                                        break;
                                    }
                                    case SET_PERK: {
                                        cap.setPerk(message.perk, message.level);
                                        break;
                                    }
                                    case REMOVE_PERK: {
                                        cap.removePerk(message.perk);
                                        break;
                                    }
                                    case ALIGNMENT: {
                                        cap.setAlignment(message.alignment);
                                        break;
                                    }
                                }
                            });
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static enum SyncType {
        ALL,
        KNOWLEDGE,
        PERKS,
        SET_PERK,
        REMOVE_PERK,
        ALIGNMENT;

    }
}

