/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.helpers.SpellHelpers;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickMoveBlockSequence
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> target;
    SpellParam<Vector3> direction;
    SpellParam<Number> maxBlocks;

    public PieceTrickMoveBlockSequence(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", SpellParam.RED, false, true);
        this.addParam(this.maxBlocks);
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam(this.direction);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException, ArithmeticException {
        super.addToMetadata(meta);
        double maxBlocksVal = SpellHelpers.ensurePositiveAndNonzero(this, this.maxBlocks);
        meta.addStat(EnumSpellStat.POTENCY, (int)(maxBlocksVal * 10.0));
        meta.addStat(EnumSpellStat.COST, (int)(18.0 + (maxBlocksVal - 1.0) * 10.5));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 directionVal = SpellHelpers.getVector3(this, context, this.direction, false, true);
        Vector3 positionVal = SpellHelpers.getVector3(this, context, this.position, true, false);
        Vector3 targetVal = SpellHelpers.getVector3(this, context, this.target, false, false);
        int maxBlocksVal = this.getParamValue(context, this.maxBlocks).intValue();
        HashMap toSet = Maps.newHashMap();
        HashMap toRemove = Maps.newHashMap();
        Vector3 directNorm = directionVal.copy().normalize();
        Vector3 targetNorm = targetVal.copy().normalize();
        LinkedHashSet<BlockPos> positions = MathHelper.getBlocksAlongRay(positionVal.toVec3D(), positionVal.copy().add(targetNorm.copy().multiply(maxBlocksVal)).toVec3D(), maxBlocksVal);
        for (BlockPos blockPos : positions) {
            BlockEvent.BreakEvent event;
            World world = context.caster.field_70170_p;
            BlockState state = world.func_180495_p(blockPos);
            if (world.func_175625_s(blockPos) != null || state.func_185905_o() != PushReaction.NORMAL || state.func_185903_a(context.caster, (IBlockReader)world, blockPos) <= 0.0f || !PieceTrickBreakBlock.canHarvestBlock(state, context.caster, world, blockPos, context.tool) || !SpellHelpers.isBlockPosInRadius(context, blockPos) || !world.func_175660_a(context.caster, blockPos) || world.func_175623_d(blockPos)) continue;
            BlockPos pushToPos = blockPos.func_177963_a(directNorm.x, directNorm.y, directNorm.z);
            BlockPos nextPos = blockPos.func_177963_a(targetNorm.x, targetNorm.y, targetNorm.z);
            BlockState pushToState = world.func_180495_p(pushToPos);
            BlockPos nextPosPushPos = nextPos.func_177963_a(directNorm.x, directNorm.y, directNorm.z);
            if (!world.func_175660_a(context.caster, pushToPos) || MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent(world, blockPos, state, context.caster)))) continue;
            if (nextPos.equals((Object)pushToPos) && positions.contains(nextPos) && (world.func_175623_d(nextPosPushPos) || world.func_180495_p(nextPosPushPos).func_185904_a().func_76222_j() || positions.contains(nextPosPushPos)) || (world.func_175623_d(pushToPos) || pushToState.func_185904_a().func_76222_j()) && pushToPos.func_177956_o() >= 0 && pushToPos.func_177956_o() <= 256) {
                toRemove.put(blockPos, state);
                toSet.put(pushToPos, state);
                continue;
            }
            return null;
        }
        for (Map.Entry entry : toRemove.entrySet()) {
            context.caster.field_70170_p.func_217377_a((BlockPos)entry.getKey(), true);
            context.caster.field_70170_p.func_217379_c(2001, (BlockPos)entry.getKey(), Block.func_196246_j((BlockState)((BlockState)entry.getValue())));
        }
        for (Map.Entry entry : toSet.entrySet()) {
            context.caster.field_70170_p.func_175656_a((BlockPos)entry.getKey(), (BlockState)entry.getValue());
        }
        return null;
    }
}

