/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.list;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntityListWrapper;
import vazkii.psi.api.spell.piece.PieceOperator;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;

public class PieceOperatorListUnion
extends PieceOperator {
    SpellParam<EntityListWrapper> list1;
    SpellParam<EntityListWrapper> list2;

    public PieceOperatorListUnion(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.list1 = new ParamEntityListWrapper("psi.spellparam.list1", SpellParam.BLUE, false, false);
        this.addParam(this.list1);
        this.list2 = new ParamEntityListWrapper("psi.spellparam.list2", SpellParam.RED, false, false);
        this.addParam(this.list2);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        List<Entity> l1 = this.getNonnullParamValue(context, this.list1).unwrap();
        List<Entity> l2 = this.getNonnullParamValue(context, this.list2).unwrap();
        ArrayList<Entity> entities = new ArrayList<Entity>(l1.size() + l2.size());
        int i = 0;
        int j = 0;
        while (i < l1.size() && j < l2.size()) {
            int cmp = EntityListWrapper.compareEntities(l1.get(i), l2.get(j));
            if (cmp == 0) {
                ++i;
                continue;
            }
            entities.add(cmp < 0 ? l1.get(i++) : l2.get(j++));
        }
        entities.addAll(l1.subList(i, l1.size()));
        entities.addAll(l2.subList(j, l2.size()));
        return new EntityListWrapper(entities);
    }

    @Override
    public Class<?> getEvaluationType() {
        return EntityListWrapper.class;
    }
}

