/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.entity;

import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntityListWrapper;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;
import vazkii.psi.common.core.helpers.SpellHelpers;
import vazkii.psi.common.spell.operator.entity.PieceOperatorClosestToPoint;

public class PieceOperatorClosestToLine
extends PieceOperator {
    SpellParam<Vector3> rayStartParam;
    SpellParam<Vector3> rayEndParam;
    SpellParam<EntityListWrapper> entList;

    public PieceOperatorClosestToLine(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        super.initParams();
        this.rayStartParam = new ParamVector("psi.spellparam.ray_start", SpellParam.RED, false, false);
        this.addParam(this.rayStartParam);
        this.rayEndParam = new ParamVector("psi.spellparam.ray_end", SpellParam.BLUE, false, false);
        this.addParam(this.rayEndParam);
        this.entList = new ParamEntityListWrapper("psi.spellparam.list", SpellParam.GREEN, false, false);
        this.addParam(this.entList);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 rayStart = SpellHelpers.getVector3(this, context, this.rayStartParam, false, false);
        Vector3 rayEnd = SpellHelpers.getVector3(this, context, this.rayEndParam, false, false);
        EntityListWrapper list = this.getNonnullParamValue(context, this.entList);
        if (list.unwrap().isEmpty()) {
            return null;
        }
        return PieceOperatorClosestToLine.closestToLineSegment(rayStart, rayEnd, list);
    }

    @Override
    public Class<?> getEvaluationType() {
        return Entity.class;
    }

    public static Entity closestToLineSegment(Vector3 a, Vector3 b, Iterable<Entity> list) throws SpellRuntimeException {
        if (a.equals(b)) {
            return PieceOperatorClosestToPoint.closestToPoint(a, list);
        }
        Vec3d start = a.toVec3D();
        Vec3d end = b.toVec3D();
        Vec3d diff = end.func_178788_d(start).func_72432_b();
        double minDot = diff.func_72430_b(start);
        double maxDot = diff.func_72430_b(end);
        double minDist = Double.MAX_VALUE;
        Entity found = null;
        for (Entity e : list) {
            Vec3d pos = e.func_174791_d();
            double dot = diff.func_72430_b(pos);
            double dist = dot <= minDot ? pos.func_178788_d(start).func_72433_c() : (dot >= maxDot ? pos.func_178788_d(end).func_72433_c() : pos.func_178788_d(start).func_72431_c(diff).func_72433_c());
            if (!(dist < minDist)) continue;
            minDist = dist;
            found = e;
        }
        if (found == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return found;
    }
}

