/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.entity;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.common.entity.EntitySpellProjectile;

public class EntitySpellGrenade
extends EntitySpellProjectile {
    @ObjectHolder(value="psi:spell_grenade")
    public static EntityType<EntitySpellGrenade> TYPE;
    boolean sound = false;

    public EntitySpellGrenade(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected EntitySpellGrenade(EntityType<? extends ThrowableEntity> type, World worldIn, LivingEntity throwerIn) {
        super(type, worldIn, throwerIn);
        double speed = 0.65;
        this.func_213317_d(this.func_213322_ci().func_216372_d(speed, speed, speed));
    }

    public EntitySpellGrenade(World world, LivingEntity thrower) {
        this(TYPE, world, thrower);
    }

    @Override
    protected float func_70185_h() {
        return 0.05f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 60 && this.func_70089_S() && this.explodes()) {
            this.doExplosion();
        }
    }

    public void doExplosion() {
        if (this.getAttackTarget() != null) {
            this.cast(context -> {
                if (context != null) {
                    context.attackedEntity = this.getAttackTarget();
                }
            });
        } else {
            this.cast();
        }
        this.func_184185_a(SoundEvents.field_187539_bB, 0.5f, 1.0f);
        double m = 0.1;
        for (int j = 0; j < 40; ++j) {
            double d0 = this.func_130014_f_().field_73012_v.nextGaussian() * m;
            double d1 = this.func_130014_f_().field_73012_v.nextGaussian() * m;
            double d2 = this.func_130014_f_().field_73012_v.nextGaussian() * m;
            double x = this.func_226277_ct_() + 0.75 * (double)this.func_130014_f_().field_73012_v.nextFloat() - 0.375;
            double y = this.func_226278_cu_() + 0.5 * (double)this.func_130014_f_().field_73012_v.nextFloat();
            double z = this.func_226281_cx_() + 0.75 * (double)this.func_130014_f_().field_73012_v.nextFloat() - 0.375;
            this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197627_t, x, y, z, d0, d1, d2);
        }
    }

    public boolean explodes() {
        return true;
    }

    @Override
    protected void func_70184_a(@Nonnull RayTraceResult ray) {
        if (ray instanceof EntityRayTraceResult && ((EntityRayTraceResult)ray).func_216348_a() instanceof LivingEntity) {
            this.field_70180_af.func_187227_b(ATTACKTARGET_UUID, Optional.of(((EntityRayTraceResult)ray).func_216348_a().func_110124_au()));
        }
        if (!this.func_130014_f_().field_72995_K && !this.sound && this.explodes()) {
            this.func_184185_a(SoundEvents.field_187572_ar, 2.0f, 1.0f);
            this.sound = true;
        }
        if (ray.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction face = ((BlockRayTraceResult)ray).func_216354_b();
            Vector3 position = Vector3.fromVec3d(ray.func_216347_e());
            if (face != Direction.UP) {
                position.add(Vector3.fromDirection(face).multiply(0.1));
            }
            this.func_70634_a(position.x, position.y, position.z);
            this.func_213317_d(Vec3d.field_186680_a);
        } else if (ray.func_216346_c() == RayTraceResult.Type.ENTITY) {
            this.func_70634_a(ray.func_216347_e().field_72450_a, ray.func_216347_e().field_72448_b, ray.func_216347_e().field_72449_c);
            this.func_213317_d(Vec3d.field_186680_a);
        }
    }
}

