/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.common.Psi;

public class EntitySpellCircle
extends Entity
implements ISpellImmune {
    @ObjectHolder(value="psi:spell_circle")
    public static EntityType<EntitySpellCircle> TYPE;
    public static final int CAST_TIMES = 20;
    public static final int CAST_DELAY = 5;
    public static final int LIVE_TIME = 110;
    private static final String TAG_COLORIZER = "colorizer";
    private static final String TAG_BULLET = "bullet";
    private static final String TAG_CASTER = "caster";
    private static final String TAG_TIME_ALIVE = "timeAlive";
    private static final String TAG_TIMES_CAST = "timesCast";
    private static final String TAG_LOOK_X = "savedLookX";
    private static final String TAG_LOOK_Y = "savedLookY";
    private static final String TAG_LOOK_Z = "savedLookZ";
    public static final DataParameter<ItemStack> COLORIZER_DATA;
    private static final DataParameter<ItemStack> BULLET_DATA;
    private static final DataParameter<Optional<UUID>> CASTER_UUID;
    private static final DataParameter<Integer> TIME_ALIVE;
    private static final DataParameter<Integer> TIMES_CAST;
    private static final DataParameter<Float> LOOK_X;
    private static final DataParameter<Float> LOOK_Y;
    private static final DataParameter<Float> LOOK_Z;

    public EntitySpellCircle(EntityType<?> type, World worldIn) {
        super(type, worldIn);
    }

    public EntitySpellCircle setInfo(PlayerEntity player, ItemStack colorizer, ItemStack bullet) {
        this.field_70180_af.func_187227_b(COLORIZER_DATA, (Object)colorizer);
        this.field_70180_af.func_187227_b(BULLET_DATA, (Object)bullet);
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(player.func_110124_au()));
        Vec3d lookVec = player.func_70676_i(1.0f);
        this.field_70180_af.func_187227_b(LOOK_X, (Object)Float.valueOf((float)lookVec.field_72450_a));
        this.field_70180_af.func_187227_b(LOOK_Y, (Object)Float.valueOf((float)lookVec.field_72448_b));
        this.field_70180_af.func_187227_b(LOOK_Z, (Object)Float.valueOf((float)lookVec.field_72449_c));
        return this;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLORIZER_DATA, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(BULLET_DATA, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(TIME_ALIVE, (Object)0);
        this.field_70180_af.func_187214_a(TIMES_CAST, (Object)0);
        this.field_70180_af.func_187214_a(LOOK_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LOOK_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LOOK_Z, (Object)Float.valueOf(0.0f));
    }

    public void func_213281_b(@Nonnull CompoundNBT tagCompound) {
        CompoundNBT colorizerCmp = new CompoundNBT();
        ItemStack colorizer = (ItemStack)this.field_70180_af.func_187225_a(COLORIZER_DATA);
        if (!colorizer.func_190926_b()) {
            colorizerCmp = colorizer.func_77955_b(colorizerCmp);
        }
        tagCompound.func_218657_a(TAG_COLORIZER, (INBT)colorizerCmp);
        CompoundNBT bulletCmp = new CompoundNBT();
        ItemStack bullet = (ItemStack)this.field_70180_af.func_187225_a(BULLET_DATA);
        if (!bullet.func_190926_b()) {
            bulletCmp = bullet.func_77955_b(bulletCmp);
        }
        tagCompound.func_218657_a(TAG_BULLET, (INBT)bulletCmp);
        ((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).ifPresent(u -> tagCompound.func_74778_a(TAG_CASTER, u.toString()));
        tagCompound.func_74768_a(TAG_TIME_ALIVE, this.getTimeAlive());
        tagCompound.func_74768_a(TAG_TIMES_CAST, ((Integer)this.field_70180_af.func_187225_a(TIMES_CAST)).intValue());
        tagCompound.func_74776_a(TAG_LOOK_X, ((Float)this.field_70180_af.func_187225_a(LOOK_X)).floatValue());
        tagCompound.func_74776_a(TAG_LOOK_Y, ((Float)this.field_70180_af.func_187225_a(LOOK_Y)).floatValue());
        tagCompound.func_74776_a(TAG_LOOK_Z, ((Float)this.field_70180_af.func_187225_a(LOOK_Z)).floatValue());
    }

    public void func_70037_a(@Nonnull CompoundNBT tagCompound) {
        CompoundNBT colorizerCmp = tagCompound.func_74775_l(TAG_COLORIZER);
        ItemStack colorizer = ItemStack.func_199557_a((CompoundNBT)colorizerCmp);
        this.field_70180_af.func_187227_b(COLORIZER_DATA, (Object)colorizer);
        CompoundNBT bulletCmp = tagCompound.func_74775_l(TAG_BULLET);
        ItemStack bullet = ItemStack.func_199557_a((CompoundNBT)bulletCmp);
        this.field_70180_af.func_187227_b(BULLET_DATA, (Object)bullet);
        if (tagCompound.func_74764_b(TAG_CASTER)) {
            this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(UUID.fromString(tagCompound.func_74779_i(TAG_CASTER))));
        }
        this.setTimeAlive(tagCompound.func_74762_e(TAG_TIME_ALIVE));
        this.field_70180_af.func_187227_b(TIMES_CAST, (Object)tagCompound.func_74762_e(TAG_TIMES_CAST));
        this.field_70180_af.func_187227_b(LOOK_X, (Object)Float.valueOf(tagCompound.func_74760_g(TAG_LOOK_X)));
        this.field_70180_af.func_187227_b(LOOK_Y, (Object)Float.valueOf(tagCompound.func_74760_g(TAG_LOOK_Y)));
        this.field_70180_af.func_187227_b(LOOK_Z, (Object)Float.valueOf(tagCompound.func_74760_g(TAG_LOOK_Z)));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int timeAlive = this.getTimeAlive();
        if (timeAlive > 110) {
            this.func_70106_y();
        }
        this.setTimeAlive(timeAlive + 1);
        int times = (Integer)this.field_70180_af.func_187225_a(TIMES_CAST);
        if (timeAlive > 5 && timeAlive % 5 == 0 && times < 20) {
            ItemStack spellContainer;
            SpellContext context = null;
            LivingEntity thrower = this.getCaster();
            if (thrower instanceof PlayerEntity && !(spellContainer = (ItemStack)this.field_70180_af.func_187225_a(BULLET_DATA)).func_190926_b() && ISpellAcceptor.isContainer(spellContainer)) {
                this.field_70180_af.func_187227_b(TIMES_CAST, (Object)(times + 1));
                Spell spell = ISpellAcceptor.acceptor(spellContainer).getSpell();
                if (spell != null) {
                    context = new SpellContext().setPlayer((PlayerEntity)thrower).setFocalPoint(this).setSpell(spell).setLoopcastIndex(times);
                }
            }
            if (context != null) {
                context.cspell.safeExecute(context);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            ItemStack colorizer = (ItemStack)this.field_70180_af.func_187225_a(COLORIZER_DATA);
            int colorVal = Psi.proxy.getColorForColorizer(colorizer);
            float r = (float)PsiRenderHelper.r(colorVal) / 255.0f;
            float g = (float)PsiRenderHelper.g(colorVal) / 255.0f;
            float b = (float)PsiRenderHelper.b(colorVal) / 255.0f;
            for (int i = 0; i < 5; ++i) {
                double x = this.func_226277_ct_() + (Math.random() - 0.5) * (double)this.func_213311_cf();
                double y = this.func_226278_cu_() - this.func_70033_W();
                double z = this.func_226281_cx_() + (Math.random() - 0.5) * (double)this.func_213311_cf();
                float grav = -0.15f - (float)Math.random() * 0.03f;
                Psi.proxy.sparkleFX(x, y, z, r, g, b, grav, 0.25f, 15);
            }
        }
    }

    public Vec3d func_70040_Z() {
        float x = ((Float)this.field_70180_af.func_187225_a(LOOK_X)).floatValue();
        float y = ((Float)this.field_70180_af.func_187225_a(LOOK_Y)).floatValue();
        float z = ((Float)this.field_70180_af.func_187225_a(LOOK_Z)).floatValue();
        return new Vec3d((double)x, (double)y, (double)z);
    }

    public int getTimeAlive() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_ALIVE);
    }

    public void setTimeAlive(int i) {
        this.field_70180_af.func_187227_b(TIME_ALIVE, (Object)i);
    }

    @Nullable
    public LivingEntity getCaster() {
        return ((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).map(arg_0 -> ((World)this.func_130014_f_()).func_217371_b(arg_0)).orElse(null);
    }

    @Override
    public boolean isImmune() {
        return true;
    }

    public boolean func_145773_az() {
        return true;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static {
        COLORIZER_DATA = EntityDataManager.func_187226_a(EntitySpellCircle.class, (IDataSerializer)DataSerializers.field_187196_f);
        BULLET_DATA = EntityDataManager.func_187226_a(EntitySpellCircle.class, (IDataSerializer)DataSerializers.field_187196_f);
        CASTER_UUID = EntityDataManager.func_187226_a(EntitySpellCircle.class, (IDataSerializer)DataSerializers.field_187203_m);
        TIME_ALIVE = EntityDataManager.func_187226_a(EntitySpellCircle.class, (IDataSerializer)DataSerializers.field_187192_b);
        TIMES_CAST = EntityDataManager.func_187226_a(EntitySpellCircle.class, (IDataSerializer)DataSerializers.field_187192_b);
        LOOK_X = EntityDataManager.func_187226_a(EntitySpellCircle.class, (IDataSerializer)DataSerializers.field_187193_c);
        LOOK_Y = EntityDataManager.func_187226_a(EntitySpellCircle.class, (IDataSerializer)DataSerializers.field_187193_c);
        LOOK_Z = EntityDataManager.func_187226_a(EntitySpellCircle.class, (IDataSerializer)DataSerializers.field_187193_c);
    }
}

