/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.recipe.ITrickRecipe;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.piece.PieceCraftingTrick;
import vazkii.psi.common.crafting.ModCraftingRecipes;
import vazkii.psi.common.item.base.ModItems;

public class TrickRecipe
implements ITrickRecipe {
    public static final IRecipeSerializer<TrickRecipe> SERIALIZER = new Serializer();
    private static final Spell dummySpell = new Spell();
    @Nullable
    private final PieceCraftingTrick piece;
    private final Ingredient input;
    private final ItemStack output;
    private final ItemStack cad;
    private final ResourceLocation id;

    public TrickRecipe(ResourceLocation id, @Nullable PieceCraftingTrick piece, Ingredient input, ItemStack output, ItemStack cad) {
        this.id = id;
        this.piece = piece;
        this.input = input;
        this.output = output;
        this.cad = cad;
    }

    @Override
    @Nullable
    public PieceCraftingTrick getPiece() {
        return this.piece;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack func_77571_b() {
        return this.output;
    }

    @Override
    public ItemStack getAssembly() {
        return this.cad;
    }

    public boolean matches(RecipeWrapper inv, World world) {
        return this.getInput().test(inv.func_70301_a(0));
    }

    public ItemStack getCraftingResult(RecipeWrapper inv) {
        return this.func_77571_b();
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModItems.cad);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Override
    public IRecipeType<?> func_222127_g() {
        return ModCraftingRecipes.TRICK_RECIPE_TYPE;
    }

    static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TrickRecipe> {
        Serializer() {
        }

        public TrickRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"), (boolean)true);
            ItemStack cadAssembly = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"cad"), (boolean)true);
            PieceCraftingTrick trick = null;
            if (json.has("trick")) {
                trick = PsiAPI.getSpellPieceRegistry().func_218349_b(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"trick"))).filter(PieceCraftingTrick.class::isAssignableFrom).map(clazz -> (PieceCraftingTrick)SpellPiece.create(clazz, dummySpell)).orElse(null);
            }
            return new TrickRecipe(id, trick, ingredient, output, cadAssembly);
        }

        @Nullable
        public TrickRecipe read(ResourceLocation id, PacketBuffer buf) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buf);
            ItemStack output = buf.func_150791_c();
            ItemStack cadAssembly = buf.func_150791_c();
            PieceCraftingTrick trick = null;
            if (buf.readBoolean()) {
                trick = PsiAPI.getSpellPieceRegistry().func_218349_b(buf.func_192575_l()).map(clazz -> (PieceCraftingTrick)SpellPiece.create(clazz, dummySpell)).orElse(null);
            }
            return new TrickRecipe(id, trick, ingredient, output, cadAssembly);
        }

        public void write(PacketBuffer buf, TrickRecipe recipe) {
            recipe.input.func_199564_a(buf);
            buf.func_150788_a(recipe.output);
            buf.func_150788_a(recipe.cad);
            if (recipe.piece != null) {
                buf.writeBoolean(true);
                buf.func_192572_a(((TrickRecipe)recipe).piece.registryKey);
            } else {
                buf.writeBoolean(false);
            }
        }
    }
}

