/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block.tile;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.AssembleCADEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ITileCADAssembler;
import vazkii.psi.api.cad.PostCADCraftEvent;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.block.tile.container.ContainerCADAssembler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.item.ItemCAD;

public class TileCADAssembler
extends TileEntity
implements ITileCADAssembler,
INamedContainerProvider {
    @ObjectHolder(value="psi:cad_assembler")
    public static TileEntityType<TileCADAssembler> TYPE;
    private final IItemHandlerModifiable inventory = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (0 < slot && slot < 6) {
                TileCADAssembler.this.clearCachedCAD();
            }
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return true;
            }
            if (slot == 0) {
                return ISocketable.isSocketable(stack);
            }
            if (slot < 6) {
                return stack.func_77973_b() instanceof ICADComponent && ((ICADComponent)stack.func_77973_b()).getComponentType(stack) == EnumCADComponent.values()[slot - 1];
            }
            return false;
        }
    };
    private final IItemHandler publicInv = new IItemHandler(){

        public int getSlots() {
            return TileCADAssembler.this.inventory.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TileCADAssembler.this.inventory.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return TileCADAssembler.this.inventory.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return TileCADAssembler.this.inventory.isItemValid(slot, stack);
        }
    };
    private ItemStack cachedCAD;

    public TileCADAssembler() {
        super(TYPE);
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.publicInv));
    }

    @Override
    public void clearCachedCAD() {
        this.cachedCAD = null;
    }

    @Override
    public ItemStack getCachedCAD(PlayerEntity player) {
        ItemStack cad = this.cachedCAD;
        if (cad == null) {
            ItemStack assembly = this.getStackForComponent(EnumCADComponent.ASSEMBLY);
            if (!assembly.func_190926_b()) {
                List<ItemStack> components = IntStream.range(1, 6).mapToObj(arg_0 -> ((IItemHandlerModifiable)this.inventory).getStackInSlot(arg_0)).collect(Collectors.toList());
                cad = ItemCAD.makeCADWithAssembly(assembly, components);
            } else {
                cad = ItemStack.field_190927_a;
            }
            AssembleCADEvent assembling = new AssembleCADEvent(cad, this, player);
            MinecraftForge.EVENT_BUS.post((Event)assembling);
            cad = assembling.isCanceled() ? ItemStack.field_190927_a : assembling.getCad();
            this.cachedCAD = cad;
        }
        return cad;
    }

    @Override
    public int getComponentSlot(EnumCADComponent componentType) {
        return componentType.ordinal() + 1;
    }

    @Override
    public ItemStack getStackForComponent(EnumCADComponent componentType) {
        return this.inventory.getStackInSlot(this.getComponentSlot(componentType));
    }

    @Override
    public boolean setStackForComponent(EnumCADComponent componentType, ItemStack component) {
        ICADComponent componentItem;
        int slot = this.getComponentSlot(componentType);
        if (component.func_190926_b()) {
            this.inventory.setStackInSlot(slot, component);
            return true;
        }
        if (component.func_77973_b() instanceof ICADComponent && (componentItem = (ICADComponent)component.func_77973_b()).getComponentType(component) == componentType) {
            this.inventory.setStackInSlot(slot, component);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getSocketableStack() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public ISocketable getSocketable() {
        return ISocketable.socketable(this.getSocketableStack());
    }

    @Override
    public boolean setSocketableStack(ItemStack stack) {
        if (stack.func_190926_b() || ISocketable.isSocketable(stack)) {
            this.inventory.setStackInSlot(0, stack);
            return true;
        }
        return false;
    }

    @Override
    public void onCraftCAD(ItemStack cad) {
        MinecraftForge.EVENT_BUS.post((Event)new PostCADCraftEvent(cad, this));
        for (int i = 1; i < 6; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, PsiSoundHandler.cadCreate, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean isBulletSlotEnabled(int slot) {
        if (this.getSocketableStack().func_190926_b()) {
            return false;
        }
        ISocketable socketable = this.getSocketable();
        return socketable != null && socketable.isSocketSlotAvailable(slot);
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("version", 1);
        tag.func_218657_a("Items", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inventory, null));
        return tag;
    }

    public void func_145839_a(@Nonnull CompoundNBT tag) {
        super.func_145839_a(tag);
        if (tag.func_74762_e("version") < 1) {
            ListNBT items = tag.func_150295_c("Items", 10);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
            LazyOptional socketable = LazyOptional.empty();
            for (int i = 0; i < items.size(); ++i) {
                if (i == 0) continue;
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)items.func_150305_b(i));
                if (i == 6) {
                    this.setSocketableStack(stack);
                    if (stack.func_190926_b()) continue;
                    socketable = stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY);
                    continue;
                }
                if (i == 1) {
                    this.setStackForComponent(EnumCADComponent.CORE, stack);
                    continue;
                }
                if (i == 2) {
                    this.setStackForComponent(EnumCADComponent.ASSEMBLY, stack);
                    continue;
                }
                if (i == 3) {
                    this.setStackForComponent(EnumCADComponent.SOCKET, stack);
                    continue;
                }
                if (i == 4) {
                    this.setStackForComponent(EnumCADComponent.BATTERY, stack);
                    continue;
                }
                if (i == 5) {
                    this.setStackForComponent(EnumCADComponent.DYE, stack);
                    continue;
                }
                int idx = i - 7;
                socketable.ifPresent(s -> s.setBulletInSocket(idx, stack));
            }
        } else {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inventory, null, (INBT)tag.func_150295_c("Items", 10));
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(ModBlocks.cadAssembler.func_149739_a(), new Object[0]);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCADAssembler(i, playerInventory, this);
    }
}

