/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.entity.EntitySpellCircle;

public class RenderSpellCircle
extends EntityRenderer<EntitySpellCircle> {
    private static final RenderType[] LAYERS = new RenderType[3];
    private static final float BRIGHTNESS_FACTOR = 0.7f;

    public RenderSpellCircle(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(EntitySpellCircle entity, float entityYaw, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        ms.func_227860_a_();
        ItemStack colorizer = (ItemStack)entity.func_184212_Q().func_187225_a(EntitySpellCircle.COLORIZER_DATA);
        int color = Psi.proxy.getColorForColorizer(colorizer);
        float alive = (float)entity.getTimeAlive() + partialTicks;
        float scale = Math.min(1.0f, alive / 5.0f);
        if (alive > 105.0f) {
            scale = 1.0f - Math.min(1.0f, Math.max(0.0f, alive - 105.0f) / 5.0f);
        }
        RenderSpellCircle.renderSpellCircle(alive, scale, 1.0f, 0.0f, 1.0f, 0.0f, color, ms, buffers);
        ms.func_227865_b_();
    }

    public static void renderSpellCircle(float alive, float scale, float horizontalScale, float xDir, float yDir, float zDir, int color, MatrixStack ms, IRenderTypeBuffer buffers) {
        ms.func_227860_a_();
        double ratio = 0.0625 * (double)horizontalScale;
        float mag = xDir * xDir + yDir * yDir + zDir * zDir;
        if ((zDir /= mag) == -1.0f) {
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        } else if (zDir != 1.0f) {
            ms.func_227863_a_(new Vector3f(-yDir / mag, xDir / mag, 0.0f).func_229187_a_((float)(Math.acos(zDir) * 180.0 / Math.PI)));
        }
        ms.func_227861_a_(0.0, 0.0, 0.1);
        ms.func_227862_a_((float)ratio * scale, (float)ratio * scale, (float)ratio);
        int r = PsiRenderHelper.r(color);
        int g = PsiRenderHelper.g(color);
        int b = PsiRenderHelper.b(color);
        for (int i = 0; i < LAYERS.length; ++i) {
            int rValue = r;
            int gValue = g;
            int bValue = b;
            if (i == 1) {
                bValue = 255;
                gValue = 255;
                rValue = 255;
            } else if (i == 2) {
                int minBrightness = 3;
                if (rValue == 0 && gValue == 0 && bValue == 0) {
                    gValue = bValue = minBrightness;
                    rValue = bValue;
                }
                if (rValue > 0 && rValue < minBrightness) {
                    rValue = minBrightness;
                }
                if (gValue > 0 && gValue < minBrightness) {
                    gValue = minBrightness;
                }
                if (bValue > 0 && bValue < minBrightness) {
                    bValue = minBrightness;
                }
                rValue = (int)Math.min((float)rValue / 0.7f, 255.0f);
                gValue = (int)Math.min((float)gValue / 0.7f, 255.0f);
                bValue = (int)Math.min((float)bValue / 0.7f, 255.0f);
            }
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(i == 0 ? -alive : alive));
            IVertexBuilder buffer = buffers.getBuffer(LAYERS[i]);
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            int fullbright = 0xF000F0;
            buffer.func_227888_a_(mat, -32.0f, 32.0f, 0.0f).func_225586_a_(rValue, gValue, bValue, 255).func_225583_a_(0.0f, 1.0f).func_227886_a_(fullbright).func_181675_d();
            buffer.func_227888_a_(mat, 32.0f, 32.0f, 0.0f).func_225586_a_(rValue, gValue, bValue, 255).func_225583_a_(1.0f, 1.0f).func_227886_a_(fullbright).func_181675_d();
            buffer.func_227888_a_(mat, 32.0f, -32.0f, 0.0f).func_225586_a_(rValue, gValue, bValue, 255).func_225583_a_(1.0f, 0.0f).func_227886_a_(fullbright).func_181675_d();
            buffer.func_227888_a_(mat, -32.0f, -32.0f, 0.0f).func_225586_a_(rValue, gValue, bValue, 255).func_225583_a_(0.0f, 0.0f).func_227886_a_(fullbright).func_181675_d();
            ms.func_227865_b_();
            ms.func_227861_a_(0.0, 0.0, -0.5);
        }
        ms.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(EntitySpellCircle entitySpellCircle) {
        return null;
    }

    static {
        for (int i = 0; i < LAYERS.length; ++i) {
            ResourceLocation texture = new ResourceLocation(String.format("psi:textures/misc/spell_circle%d.png", i));
            RenderType.State glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228714_a_(new RenderState.CullState(false)).func_228713_a_(new RenderState.AlphaState(0.004f)).func_228719_a_(new RenderState.LightmapState(true)).func_228728_a_(true);
            RenderSpellCircle.LAYERS[i] = RenderType.func_228633_a_((String)("psi:spell_circle_" + i), (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)64, (boolean)false, (boolean)false, (RenderType.State)glState);
        }
    }
}

