/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import com.google.common.base.CaseFormat;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;

public abstract class SpellPiece {
    @OnlyIn(value=Dist.CLIENT)
    private static RenderType layer;
    private static final String TAG_KEY_LEGACY = "spellKey";
    private static final String TAG_KEY = "key";
    private static final String TAG_PARAMS = "params";
    private static final String TAG_COMMENT = "comment";
    private static final String PSI_PREFIX = "psi.spellparam.";
    public final ResourceLocation registryKey;
    public final Spell spell;
    public boolean isInGrid = false;
    public int x;
    public int y;
    public String comment;
    public final Map<String, SpellParam<?>> params = new LinkedHashMap();
    public final Map<SpellParam<?>, SpellParam.Side> paramSides = new LinkedHashMap();

    public SpellPiece(Spell spell) {
        this.spell = spell;
        this.registryKey = PsiAPI.getSpellPieceKey(this.getClass());
        this.initParams();
    }

    public void initParams() {
    }

    public abstract EnumPieceType getPieceType();

    public abstract Class<?> getEvaluationType();

    public abstract Object evaluate() throws SpellCompilationException;

    public abstract Object execute(SpellContext var1) throws SpellRuntimeException;

    public ITextComponent getEvaluationTypeString() {
        Class<?> evalType = this.getEvaluationType();
        String evalStr = evalType == null ? "null" : CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, evalType.getSimpleName());
        TranslationTextComponent s = new TranslationTextComponent("psi.datatype." + evalStr, new Object[0]);
        if (this.getPieceType() == EnumPieceType.CONSTANT) {
            s.func_150257_a((ITextComponent)new StringTextComponent(" ")).func_150257_a((ITextComponent)new TranslationTextComponent("psimisc.constant", new Object[0]));
        }
        return s;
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
    }

    public void addParam(SpellParam<?> param) {
        this.params.put(param.name, param);
        this.paramSides.put(param, SpellParam.Side.OFF);
    }

    public <T> T getParamValueOrDefault(SpellContext context, SpellParam<T> param, T def) {
        T v = this.getParamValue(context, param);
        return v == null ? def : v;
    }

    public <T> T getNonnullParamValue(SpellContext context, SpellParam<T> param) throws SpellRuntimeException {
        T v = this.getParamValue(context, param);
        if (v == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        return v;
    }

    public <T> T getParamValue(SpellContext context, SpellParam<T> param) {
        SpellParam.Side side = this.paramSides.get(param);
        if (!side.isEnabled()) {
            return null;
        }
        try {
            SpellPiece piece = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, side);
            if (piece == null || !param.canAccept(piece)) {
                return null;
            }
            return (T)context.evaluatedObjects[piece.x][piece.y];
        }
        catch (SpellCompilationException e) {
            return null;
        }
    }

    public <T> T getParamEvaluationeOrDefault(SpellParam<T> param, T def) throws SpellCompilationException {
        T v = this.getParamEvaluation(param);
        return v == null ? def : v;
    }

    public <T> T getNonNullParamEvaluation(SpellParam<T> param) throws SpellCompilationException {
        T v = this.getParamEvaluation(param);
        if (v == null) {
            throw new SpellCompilationException("psi.spellerror.nullparam", this.x, this.y);
        }
        return v;
    }

    public <T> T getParamEvaluation(SpellParam<?> param) throws SpellCompilationException {
        SpellParam.Side side = this.paramSides.get(param);
        if (!side.isEnabled()) {
            return null;
        }
        SpellPiece piece = this.spell.grid.getPieceAtSideWithRedirections(this.x, this.y, side);
        if (piece == null || !param.canAccept(piece)) {
            return null;
        }
        return (T)piece.evaluate();
    }

    public String getUnlocalizedName() {
        return this.registryKey.func_110624_b() + ".spellpiece." + this.registryKey.func_110623_a();
    }

    public String getSortingName() {
        return new TranslationTextComponent(this.getUnlocalizedName(), new Object[0]).func_150254_d();
    }

    public String getUnlocalizedDesc() {
        return this.registryKey.func_110624_b() + ".spellpiece." + this.registryKey.func_110623_a() + ".desc";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        ms.func_227860_a_();
        this.drawBackground(ms, buffers, light);
        ms.func_227861_a_(0.0, 0.0, (double)0.1f);
        this.drawAdditional(ms, buffers, light);
        if (this.isInGrid) {
            ms.func_227861_a_(0.0, 0.0, (double)0.1f);
            this.drawParams(ms, buffers, light);
            ms.func_227861_a_(0.0, 0.0, (double)0.1f);
            this.drawComment(ms, buffers, light);
        }
        ms.func_227865_b_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType getLayer() {
        if (layer == null) {
            RenderType.State glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(PsiAPI.PSI_PIECE_TEXTURE_ATLAS, false, false)).func_228719_a_(new RenderState.LightmapState(true)).func_228713_a_(new RenderState.AlphaState(0.004f)).func_228714_a_(new RenderState.CullState(false)).func_228728_a_(false);
            layer = RenderType.func_228632_a_((String)PsiAPI.PSI_PIECE_TEXTURE_ATLAS.toString(), (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)64, (RenderType.State)glState);
        }
        return layer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        Material material = PsiAPI.getSpellPieceMaterial(this.registryKey);
        IVertexBuilder buffer = material.func_229311_a_(buffers, ignored -> SpellPiece.getLayer());
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, 0.0f, 16.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.func_225583_a_(0.0f, 1.0f).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 16.0f, 16.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.func_225583_a_(1.0f, 1.0f).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 16.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.func_225583_a_(1.0f, 0.0f).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.func_225583_a_(0.0f, 0.0f).func_227886_a_(light).func_181675_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawAdditional(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawComment(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        if (this.comment != null && !this.comment.isEmpty()) {
            IVertexBuilder buffer = buffers.getBuffer(PsiAPI.internalHandler.getProgrammerLayer());
            float wh = 6.0f;
            float minU = 0.5859375f;
            float minV = 0.71875f;
            float maxU = (150.0f + wh) / 256.0f;
            float maxV = (184.0f + wh) / 256.0f;
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            buffer.func_227888_a_(mat, -2.0f, 4.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, 4.0f, 4.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, 4.0f, -2.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, -2.0f, -2.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_181675_d();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawParams(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        IVertexBuilder buffer = buffers.getBuffer(PsiAPI.internalHandler.getProgrammerLayer());
        for (SpellParam<?> param : this.paramSides.keySet()) {
            SpellParam.Side side = this.paramSides.get(param);
            if (!side.isEnabled()) continue;
            int minX = 4;
            int minY = 4;
            int maxX = (minX += side.offx * 9) + 8;
            int maxY = (minY += side.offy * 9) + 8;
            float wh = 8.0f;
            float minU = (float)side.u / 256.0f;
            float minV = (float)side.v / 256.0f;
            float maxU = ((float)side.u + wh) / 256.0f;
            float maxV = ((float)side.v + wh) / 256.0f;
            int r = PsiRenderHelper.r(param.color);
            int g = PsiRenderHelper.g(param.color);
            int b = PsiRenderHelper.b(param.color);
            int a = 255;
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            buffer.func_227888_a_(mat, (float)minX, (float)maxY, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, (float)maxX, (float)maxY, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, (float)maxX, (float)minY, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, (float)minX, (float)minY, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_227886_a_(light).func_181675_d();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTooltip(int tooltipX, int tooltipY, List<ITextComponent> tooltip, Screen screen) {
        PsiAPI.internalHandler.renderTooltip(tooltipX, tooltipY, tooltip, 0x505000FF, -267386864, screen.width, screen.height);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawCommentText(int tooltipX, int tooltipY, List<ITextComponent> commentText, Screen screen) {
        PsiAPI.internalHandler.renderTooltip(tooltipX, tooltipY - 9 - commentText.size() * 10, commentText, 0x5000A000, -268427776, screen.width, screen.height);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getTooltip(List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)new TranslationTextComponent(this.getUnlocalizedName(), new Object[0]));
        TooltipHelper.tooltipIfShift(tooltip, () -> this.addToTooltipAfterShift(tooltip));
        String addon = this.registryKey.func_110624_b();
        if (!addon.equals("psi") && ModList.get().getModContainerById(addon).isPresent()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("psimisc.provider_mod", new Object[]{((ModContainer)ModList.get().getModContainerById(addon).get()).getNamespace()}));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addToTooltipAfterShift(List<ITextComponent> tooltip) {
        tooltip.add(new TranslationTextComponent(this.getUnlocalizedDesc(), new Object[0]).func_211708_a(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(""));
        ITextComponent eval = this.getEvaluationTypeString().func_211708_a(TextFormatting.GOLD);
        tooltip.add(new StringTextComponent("Output ").func_150257_a(eval));
        for (SpellParam<?> param : this.paramSides.keySet()) {
            ITextComponent pName = new TranslationTextComponent(param.name, new Object[0]).func_211708_a(TextFormatting.YELLOW);
            ITextComponent pEval = new StringTextComponent(" [").func_150257_a(param.getRequiredTypeString()).func_150258_a("]").func_211708_a(TextFormatting.YELLOW);
            tooltip.add(new StringTextComponent(param.canDisable ? "[Input] " : " Input  ").func_150257_a(pName).func_150257_a(pEval));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean interceptKeystrokes() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onCharTyped(char character, int keyCode, boolean doit) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onKeyPressed(int keyCode, int scanCode, boolean doit) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasConfig() {
        return !this.params.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getShownPieces(List<SpellPiece> pieces) {
        pieces.add(this);
    }

    public static SpellPiece createFromNBT(Spell spell, CompoundNBT cmp) {
        String key = cmp.func_74764_b(TAG_KEY_LEGACY) ? cmp.func_74779_i(TAG_KEY_LEGACY) : cmp.func_74779_i(TAG_KEY);
        if (key.startsWith("_")) {
            key = PSI_PREFIX + key.substring(1);
        }
        try {
            key = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean exists = false;
        ResourceLocation rl = new ResourceLocation(key);
        if (PsiAPI.isPieceRegistered(rl)) {
            exists = true;
        } else {
            Set pieceNamespaces = PsiAPI.getSpellPieceRegistry().func_148742_b().stream().map(ResourceLocation::func_110624_b).collect(Collectors.toSet());
            for (String namespace : pieceNamespaces) {
                rl = new ResourceLocation(namespace, key);
                if (!PsiAPI.isPieceRegistered(rl)) continue;
                exists = true;
            }
        }
        if (exists) {
            Class<? extends SpellPiece> clazz = PsiAPI.getSpellPiece(rl);
            SpellPiece p = SpellPiece.create(clazz, spell);
            p.readFromNBT(cmp);
            return p;
        }
        return null;
    }

    public static SpellPiece create(Class<? extends SpellPiece> clazz, Spell spell) {
        try {
            return clazz.getConstructor(Spell.class).newInstance(spell);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SpellPiece copy() {
        CompoundNBT cmp = new CompoundNBT();
        this.writeToNBT(cmp);
        return SpellPiece.createFromNBT(this.spell, cmp);
    }

    public SpellPiece copyFromSpell(Spell spell) {
        CompoundNBT cmp = new CompoundNBT();
        this.writeToNBT(cmp);
        return SpellPiece.createFromNBT(spell, cmp);
    }

    public void readFromNBT(CompoundNBT cmp) {
        CompoundNBT paramCmp = cmp.func_74775_l(TAG_PARAMS);
        for (String s : this.params.keySet()) {
            SpellParam<?> param = this.params.get(s);
            String key = s;
            if (paramCmp.func_74764_b(key)) {
                this.paramSides.put(param, SpellParam.Side.fromInt(paramCmp.func_74762_e(key)));
                continue;
            }
            if (key.startsWith(PSI_PREFIX)) {
                key = "_" + key.substring(PSI_PREFIX.length());
            }
            this.paramSides.put(param, SpellParam.Side.fromInt(paramCmp.func_74762_e(key)));
        }
        this.comment = cmp.func_74779_i(TAG_COMMENT);
    }

    public void writeToNBT(CompoundNBT cmp) {
        if (this.comment == null) {
            this.comment = "";
        }
        cmp.func_74778_a(TAG_KEY, this.registryKey.toString().replaceAll("^psi.spellparam.", "_"));
        int paramCount = 0;
        CompoundNBT paramCmp = new CompoundNBT();
        for (String s : this.params.keySet()) {
            SpellParam<?> param = this.params.get(s);
            SpellParam.Side side = this.paramSides.get(param);
            paramCmp.func_74768_a(s.replaceAll("^psi.spellparam.", "_"), side.asInt());
            ++paramCount;
        }
        if (paramCount > 0) {
            cmp.func_218657_a(TAG_PARAMS, (INBT)paramCmp);
        }
        if (!this.comment.isEmpty()) {
            cmp.func_74778_a(TAG_COMMENT, this.comment);
        }
    }
}

