/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.common.network;

import com.teamabnormals.abnormals_core.client.ClientInfo;
import com.teamabnormals.abnormals_core.common.tileentity.AbnormalsSignTileEntity;
import com.teamabnormals.abnormals_core.core.utils.NetworkUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSOpenSignEditor {
    public UUID playerUUID;
    public BlockPos signPos;

    public MessageSOpenSignEditor(UUID playerUUID, BlockPos signPos) {
        this.playerUUID = playerUUID;
        this.signPos = signPos;
    }

    public void serialize(PacketBuffer buf) {
        buf.func_179252_a(this.playerUUID);
        buf.func_179255_a(this.signPos);
    }

    public static MessageSOpenSignEditor deserialize(PacketBuffer buf) {
        return new MessageSOpenSignEditor(buf.func_179253_g(), buf.func_179259_c());
    }

    public static void handle(MessageSOpenSignEditor message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            if (!ClientInfo.getClientPlayer().func_110124_au().equals(message.playerUUID)) {
                return;
            }
            context.enqueueWork(() -> {
                TileEntity tileentity = ClientInfo.getClientPlayerWorld().func_175625_s(message.signPos);
                if (!(tileentity instanceof AbnormalsSignTileEntity)) {
                    tileentity = new AbnormalsSignTileEntity();
                    tileentity.func_226984_a_(ClientInfo.getClientPlayerWorld(), message.signPos);
                }
                NetworkUtil.openSignScreen((AbnormalsSignTileEntity)tileentity);
            });
        }
        context.setPacketHandled(true);
    }
}

