/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.common.blocks.sign;

import com.teamabnormals.abnormals_core.common.tileentity.AbnormalsSignTileEntity;
import com.teamabnormals.abnormals_core.core.config.ACConfig;
import com.teamabnormals.abnormals_core.core.utils.NetworkUtil;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class AbnormalsAbstractSignBlock
extends AbstractSignBlock {
    private final ResourceLocation textureLocation;

    public AbnormalsAbstractSignBlock(Block.Properties properties, ResourceLocation textureLocation) {
        super(properties, null);
        this.textureLocation = textureLocation;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean canDye;
        ItemStack itemstack = player.func_184586_b(handIn);
        boolean canEdit = player.field_71075_bZ.field_75099_e;
        boolean bl = canDye = itemstack.func_77973_b() instanceof DyeItem && canEdit;
        if (worldIn.field_72995_K) {
            return canDye ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof AbnormalsSignTileEntity) {
            AbnormalsSignTileEntity signtileentity = (AbnormalsSignTileEntity)tileentity;
            if (canDye) {
                boolean tryToSetColor = signtileentity.setTextColor(((DyeItem)itemstack.func_77973_b()).func_195962_g());
                if (tryToSetColor) {
                    NetworkUtil.updateSignText(pos, signtileentity.getText(0), signtileentity.getText(1), signtileentity.getText(2), signtileentity.getText(3), signtileentity.getTextColor());
                    if (!player.func_184812_l_()) {
                        itemstack.func_190918_g(1);
                    }
                }
            } else if (canEdit && !this.doesSignHaveCommand(signtileentity) && ACConfig.ValuesHolder.isQuarkSignEditingEnabled() && (!ACConfig.ValuesHolder.doesSignEditingRequireEmptyHand() || itemstack.func_190926_b()) && !player.func_225608_bj_()) {
                NetworkUtil.openSignEditor(player, signtileentity);
                return ActionResultType.SUCCESS;
            }
            return signtileentity.executeCommand(player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    private boolean doesSignHaveCommand(AbnormalsSignTileEntity sign) {
        for (ITextComponent itextcomponent : sign.signText) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = itextcomponent == null ? null : itextcomponent.func_150256_b();
            if (style == null || style.func_150235_h() == null || (clickevent = style.func_150235_h()).func_150669_a() != ClickEvent.Action.RUN_COMMAND) continue;
            return true;
        }
        return false;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new AbnormalsSignTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

