/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.wire;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.mechanisms.api.ConnectionType;
import net.silentchaos512.mechanisms.block.wire.WireBlock;
import net.silentchaos512.mechanisms.block.wire.WireTileEntity;
import net.silentchaos512.mechanisms.util.EnergyUtils;

public final class WireNetwork
implements IEnergyStorage {
    public static final int TRANSFER_PER_CONNECTION = 1000;
    private final IWorldReader world;
    private final Map<BlockPos, Set<Connection>> connections = new HashMap<BlockPos, Set<Connection>>();
    private boolean connectionsBuilt;
    private int energyStored;

    private WireNetwork(IWorldReader world, Set<BlockPos> wires, int energyStored) {
        this.world = world;
        wires.forEach(pos -> this.connections.put((BlockPos)pos, Collections.emptySet()));
        this.energyStored = energyStored;
    }

    public boolean contains(IWorldReader world, BlockPos pos) {
        return this.world == world && this.connections.containsKey(pos);
    }

    public int getWireCount() {
        return this.connections.size();
    }

    public Connection getConnection(BlockPos pos, Direction side) {
        if (this.connections.containsKey(pos)) {
            for (Connection connection : this.connections.get(pos)) {
                if (connection.side != side) continue;
                return connection;
            }
        }
        return new Connection(this, side, ConnectionType.NONE);
    }

    private void updateWireEnergy() {
        int energyPerWire = this.energyStored / this.getWireCount();
        this.connections.keySet().forEach(p -> {
            TileEntity tileEntity = this.world.func_175625_s(p);
            if (tileEntity instanceof WireTileEntity) {
                ((WireTileEntity)tileEntity).energyStored = energyPerWire;
            }
        });
    }

    void invalidate() {
        this.connections.values().forEach(set -> set.forEach(con -> con.getLazyOptional().invalidate()));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        this.buildConnections();
        int received = Math.min(this.getMaxEnergyStored() - this.energyStored, Math.min(maxReceive, 1000));
        if (received > 0 && !simulate) {
            this.energyStored += received;
            this.updateWireEnergy();
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        this.buildConnections();
        int extracted = Math.min(this.energyStored, Math.min(maxExtract, 1000));
        if (extracted > 0 && !simulate) {
            this.energyStored -= extracted;
            this.updateWireEnergy();
        }
        return extracted;
    }

    void sendEnergy() {
        this.buildConnections();
        for (Map.Entry<BlockPos, Set<Connection>> entry : this.connections.entrySet()) {
            BlockPos pos = entry.getKey();
            Set<Connection> connections = entry.getValue();
            for (Connection con : connections) {
                IEnergyStorage energy;
                if (!con.type.canExtract() || (energy = EnergyUtils.getEnergy(this.world, pos.func_177972_a(con.side))) == null || !energy.canReceive()) continue;
                int toSend = this.extractEnergy(1000, true);
                int accepted = energy.receiveEnergy(toSend, false);
                this.extractEnergy(accepted, false);
            }
        }
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return 1000 * this.connections.size();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    static WireNetwork buildNetwork(IWorldReader world, BlockPos pos) {
        Set<BlockPos> wires = WireNetwork.buildWireSet(world, pos);
        int energyStored = wires.stream().mapToInt(p -> {
            TileEntity tileEntity = world.func_175625_s(p);
            return tileEntity instanceof WireTileEntity ? ((WireTileEntity)tileEntity).energyStored : 0;
        }).sum();
        return new WireNetwork(world, wires, energyStored);
    }

    private static Set<BlockPos> buildWireSet(IWorldReader world, BlockPos pos) {
        return WireNetwork.buildWireSet(world, pos, new HashSet<BlockPos>());
    }

    private static Set<BlockPos> buildWireSet(IWorldReader world, BlockPos pos, Set<BlockPos> set) {
        set.add(pos);
        for (Direction side : Direction.values()) {
            BlockPos pos1 = pos.func_177972_a(side);
            if (set.contains(pos1) || !(world.func_175625_s(pos1) instanceof WireTileEntity)) continue;
            set.add(pos1);
            set.addAll(WireNetwork.buildWireSet(world, pos1, set));
        }
        return set;
    }

    private void buildConnections() {
        if (!this.connectionsBuilt) {
            this.connections.keySet().forEach(p -> this.connections.put((BlockPos)p, this.getConnections((IBlockReader)this.world, (BlockPos)p)));
            this.connectionsBuilt = true;
        }
    }

    private Set<Connection> getConnections(IBlockReader world, BlockPos pos) {
        HashSet<Connection> connections = new HashSet<Connection>();
        for (Direction direction : Direction.values()) {
            TileEntity te = world.func_175625_s(pos.func_177972_a(direction));
            if (te == null || te instanceof WireTileEntity || !te.getCapability(CapabilityEnergy.ENERGY).isPresent()) continue;
            ConnectionType type = WireBlock.getConnection(world.func_180495_p(pos), direction);
            connections.add(new Connection(this, direction, type));
        }
        return connections;
    }

    public String toString() {
        return String.format("WireNetwork %s, %d wires, %,d FE", Integer.toHexString(this.hashCode()), this.connections.size(), this.energyStored);
    }

    public static class Connection
    implements IEnergyStorage {
        private final WireNetwork network;
        private final Direction side;
        private final ConnectionType type;
        private final LazyOptional<Connection> lazyOptional;

        Connection(WireNetwork network, Direction side, ConnectionType type) {
            this.network = network;
            this.side = side;
            this.type = type;
            this.lazyOptional = LazyOptional.of(() -> this);
        }

        public LazyOptional<Connection> getLazyOptional() {
            return this.lazyOptional;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            return this.network.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0;
            }
            return this.network.extractEnergy(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return this.network.energyStored;
        }

        public int getMaxEnergyStored() {
            return this.network.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return this.type.canExtract();
        }

        public boolean canReceive() {
            return this.type.canReceive();
        }
    }
}

