/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import javax.annotation.Nonnull;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ModuleHelper {
    public static final String NBT_FLAGS = "Flags";
    public static final String NBT_REDSTONE_MODE = "RedstoneMode";
    public static final String NBT_REGULATOR_AMOUNT = "RegulatorAmount";
    public static final String NBT_FILTER = "ModuleFilter";
    public static final String NBT_AUGMENTS = "Augments";
    public static final String NBT_MATCH_ALL = "MatchAll";

    @Nonnull
    public static CompoundNBT validateNBT(ItemStack stack) {
        CompoundNBT compound = stack.func_190925_c("modularrouters");
        if (compound.func_150299_b(NBT_FLAGS) != 1) {
            byte flags = 0;
            for (ItemModule.ModuleFlags b : ItemModule.ModuleFlags.values()) {
                if (!b.getDefaultValue()) continue;
                flags = (byte)(flags | b.getMask());
            }
            compound.func_74774_a(NBT_FLAGS, flags);
        }
        if (compound.func_150299_b(NBT_FILTER) != 10) {
            compound.func_218657_a(NBT_FILTER, (INBT)new CompoundNBT());
        }
        return compound;
    }

    public static boolean isBlacklist(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, ItemModule.ModuleFlags.BLACKLIST);
    }

    public static boolean ignoreDamage(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, ItemModule.ModuleFlags.IGNORE_DAMAGE);
    }

    public static boolean ignoreNBT(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, ItemModule.ModuleFlags.IGNORE_NBT);
    }

    public static boolean ignoreTags(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, ItemModule.ModuleFlags.IGNORE_TAGS);
    }

    public static boolean terminates(ItemStack stack) {
        return ModuleHelper.checkFlag(stack, ItemModule.ModuleFlags.TERMINATE);
    }

    public static boolean checkFlag(ItemStack stack, ItemModule.ModuleFlags flag) {
        CompoundNBT compound = ModuleHelper.validateNBT(stack);
        return (compound.func_74771_c(NBT_FLAGS) & flag.getMask()) != 0;
    }

    public static ItemModule.RelativeDirection getDirectionFromNBT(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemModule && ((ItemModule)stack.func_77973_b()).isDirectional()) {
            CompoundNBT compound = ModuleHelper.validateNBT(stack);
            return ItemModule.RelativeDirection.values()[(compound.func_74771_c(NBT_FLAGS) & 0x70) >> 4];
        }
        return ItemModule.RelativeDirection.NONE;
    }

    public static int getRegulatorAmount(ItemStack itemstack) {
        CompoundNBT compound = ModuleHelper.validateNBT(itemstack);
        return compound.func_74762_e(NBT_REGULATOR_AMOUNT);
    }

    public static RouterRedstoneBehaviour getRedstoneBehaviour(ItemStack stack) {
        ItemAugment.AugmentCounter counter = new ItemAugment.AugmentCounter(stack);
        if (counter.getAugmentCount((Item)ModItems.REDSTONE_AUGMENT.get()) > 0) {
            CompoundNBT compound = ModuleHelper.validateNBT(stack);
            try {
                return RouterRedstoneBehaviour.values()[compound.func_74771_c(NBT_REDSTONE_MODE)];
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                return RouterRedstoneBehaviour.ALWAYS;
            }
        }
        return RouterRedstoneBehaviour.ALWAYS;
    }

    public static int getRangeModifier(ItemStack stack) {
        ItemAugment.AugmentCounter counter = new ItemAugment.AugmentCounter(stack);
        return counter.getAugmentCount((Item)ModItems.RANGE_UP_AUGMENT.get()) - counter.getAugmentCount((Item)ModItems.RANGE_DOWN_AUGMENT.get());
    }

    public static boolean isMatchAll(ItemStack stack) {
        CompoundNBT compound = ModuleHelper.validateNBT(stack);
        return compound.func_74767_n(NBT_MATCH_ALL);
    }
}

