/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.IPlayerOwned;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SecurityUpgrade
extends ItemUpgrade
implements IPlayerOwned {
    private static final String NBT_PLAYERS = "Players";
    private static final int MAX_PLAYERS = 6;

    @Override
    public void addExtraInformation(ItemStack itemstack, List<ITextComponent> list) {
        String owner = this.getOwnerName(itemstack);
        if (owner == null) {
            owner = "(none)";
        }
        list.add((ITextComponent)new TranslationTextComponent("itemText.security.owner", new Object[]{TextFormatting.YELLOW + this.getOwnerName(itemstack)}));
        Set<String> names = SecurityUpgrade.getPlayerNames(itemstack);
        if (!names.isEmpty()) {
            list.add((ITextComponent)new TranslationTextComponent("itemText.security.count", new Object[]{names.size(), 6}));
            list.addAll(names.stream().map(name -> " \u2022 " + TextFormatting.YELLOW + name).sorted().map(StringTextComponent::new).collect(Collectors.toList()));
        }
    }

    @Override
    public void onCompiled(ItemStack stack, TileEntityItemRouter router) {
        super.onCompiled(stack, router);
        router.addPermittedIds(this.getPlayerIDs(stack));
    }

    @Override
    public TintColor getItemTint() {
        return new TintColor(64, 64, 255);
    }

    private Set<UUID> getPlayerIDs(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound == null) {
            return Collections.emptySet();
        }
        HashSet res = Sets.newHashSet();
        UUID ownerID = this.getOwnerID(stack);
        if (ownerID == null) {
            return Collections.emptySet();
        }
        res.add(ownerID);
        if (compound.func_74764_b(NBT_PLAYERS)) {
            CompoundNBT p = compound.func_74775_l(NBT_PLAYERS);
            res.addAll(p.func_150296_c().stream().map(UUID::fromString).collect(Collectors.toList()));
        }
        return res;
    }

    private static Set<String> getPlayerNames(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b(NBT_PLAYERS)) {
            CompoundNBT p = compound.func_74775_l(NBT_PLAYERS);
            return Sets.newHashSet((Iterable)p.func_150296_c().stream().map(arg_0 -> ((CompoundNBT)p).func_74779_i(arg_0)).sorted().collect(Collectors.toList()));
        }
        return Collections.emptySet();
    }

    private static Result addPlayer(ItemStack stack, String id, String name) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null) {
            CompoundNBT p;
            if (!compound.func_74764_b(NBT_PLAYERS)) {
                compound.func_218657_a(NBT_PLAYERS, (INBT)new CompoundNBT());
            }
            if ((p = compound.func_74775_l(NBT_PLAYERS)).func_74764_b(id)) {
                return Result.ALREADY_ADDED;
            }
            if (p.func_186856_d() >= 6) {
                return Result.FULL;
            }
            p.func_74778_a(id, name);
            return Result.ADDED;
        }
        return Result.ERROR;
    }

    private static Result removePlayer(ItemStack stack, String id) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null) {
            CompoundNBT p;
            if (!compound.func_74764_b(NBT_PLAYERS)) {
                compound.func_218657_a(NBT_PLAYERS, (INBT)new CompoundNBT());
            }
            if ((p = compound.func_74775_l(NBT_PLAYERS)).func_74764_b(id)) {
                p.func_82580_o(id);
                return Result.REMOVED;
            }
            return Result.NOT_PRESENT;
        }
        return Result.ERROR;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_130014_f_().field_72995_K && player.func_226271_bk_()) {
            this.setOwner(stack, player);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("itemText.security.owner", new Object[]{player.func_145748_c_().getString()}), false);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (entity instanceof PlayerEntity) {
            Result res;
            PlayerEntity targetPlayer = (PlayerEntity)entity;
            String id = targetPlayer.func_110124_au().toString();
            String name = targetPlayer.func_145748_c_().toString();
            Result result = res = player.func_226271_bk_() ? SecurityUpgrade.removePlayer(stack, id) : SecurityUpgrade.addPlayer(stack, id, name);
            if (player.field_70170_p.field_72995_K) {
                player.func_184185_a(res.isError() ? (SoundEvent)ModSounds.ERROR.get() : (SoundEvent)ModSounds.SUCCESS.get(), 1.0f, 1.0f);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chatText.security." + res.toString(), new Object[]{name}), false);
            }
            return true;
        }
        return false;
    }

    static enum Result {
        ADDED,
        REMOVED,
        FULL,
        ALREADY_ADDED,
        ERROR,
        NOT_PRESENT;


        boolean isError() {
            return this != ADDED && this != REMOVED;
        }
    }
}

