/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.ItemModule;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;

public class AugmentHandler
extends ItemStackHandler {
    private final ItemStack holderStack;
    private final TileEntityItemRouter router;

    public AugmentHandler(ItemStack holderStack, TileEntityItemRouter router) {
        super(4);
        this.router = router;
        Validate.isTrue((boolean)(holderStack.func_77973_b() instanceof ItemModule), (String)"holder stack must be a module!", (Object[])new Object[0]);
        this.holderStack = holderStack;
        this.deserializeNBT(holderStack.func_190925_c("modularrouters").func_74775_l("Augments"));
    }

    public ItemStack getHolderStack() {
        return this.holderStack;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemAugment)) {
            return false;
        }
        ItemAugment augment = (ItemAugment)stack.func_77973_b();
        if (augment.getMaxAugments((ItemModule)this.holderStack.func_77973_b()) == 0) {
            return false;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            if (slot == i || stack.func_77973_b() != this.getStackInSlot(i).func_77973_b()) continue;
            return false;
        }
        return true;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemAugment) {
            ItemAugment augment = (ItemAugment)stack.func_77973_b();
            return augment.getMaxAugments((ItemModule)this.holderStack.func_77973_b());
        }
        return 0;
    }

    protected void onContentsChanged(int slot) {
        this.save();
    }

    private void save() {
        this.holderStack.func_190925_c("modularrouters").func_218657_a("Augments", (INBT)this.serializeNBT());
        if (this.router != null) {
            this.router.recompileNeeded(1);
        }
    }
}

