/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.widgets.GuiContainerBase;
import me.desht.modularrouters.client.gui.widgets.button.RedstoneBehaviourButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.container.ContainerItemRouter;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.OpenGuiMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.RouterSettingsMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiItemRouter
extends GuiContainerBase<ContainerItemRouter>
implements ISendToServer,
IHasContainer<ContainerItemRouter> {
    private static final ResourceLocation textureLocation = new ResourceLocation("modularrouters", "textures/gui/router.png");
    private static final int LABEL_YPOS = 5;
    private static final int MODULE_LABEL_YPOS = 60;
    private static final int BUFFER_LABEL_YPOS = 28;
    private static final int UPGRADES_LABEL_YPOS = 28;
    private static final int GUI_HEIGHT = 186;
    private static final int GUI_WIDTH = 176;
    private static final int BUTTON_HEIGHT = 16;
    private static final int BUTTON_WIDTH = 16;
    private static final int MODULE_START = 37;
    private static final int MODULE_END = 45;
    public final TileEntityItemRouter router;
    private RedstoneBehaviourButton rrb;
    private RouterEcoButton reb;

    public GuiItemRouter(ContainerItemRouter container, PlayerInventory inventoryPlayer, ITextComponent displayName) {
        super(container, inventoryPlayer, displayName);
        this.field_146999_f = 176;
        this.field_147000_g = 186;
        this.router = container.getRouter();
        this.passEvents = true;
    }

    public void init() {
        super.init();
        this.rrb = new RedstoneBehaviourButton(this.field_147003_i + 152, this.field_147009_r + 10, 16, 16, this.router.getRedstoneBehaviour(), (ISendToServer)this);
        this.addButton((Widget)this.rrb);
        this.reb = new RouterEcoButton(this.field_147003_i + 132, this.field_147009_r + 10, 16, 16, this.router.getEcoMode());
        this.addButton((Widget)this.reb);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String title = I18n.func_135052_a((String)"block.modularrouters.item_router", (Object[])new Object[0]);
        this.font.func_211126_b(title, (float)this.field_146999_f / 2.0f - (float)this.font.func_78256_a(title) / 2.0f, 5.0f, -12566464);
        this.font.func_211126_b(I18n.func_135052_a((String)"guiText.label.buffer", (Object[])new Object[0]), 8.0f, 28.0f, -12566464);
        this.font.func_211126_b(I18n.func_135052_a((String)"guiText.label.upgrades", (Object[])new Object[0]), 80.0f, 28.0f, -12566464);
        this.font.func_211126_b(I18n.func_135052_a((String)"guiText.label.modules", (Object[])new Object[0]), 8.0f, 60.0f, -12566464);
        this.font.func_211126_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8.0f, (float)(this.field_147000_g - 96 + 4), -12566464);
    }

    protected void func_146976_a(float v, int i, int i1) {
        this.minecraft.func_110434_K().func_110577_a(textureLocation);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return ClientSetup.keybindConfigure.getKey().func_197937_c() == keyCode ? this.handleModuleConfig() : super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean mouseClicked(double x, double y, int btn) {
        return btn == 2 ? this.handleModuleConfig() : super.mouseClicked(x, y, btn);
    }

    private boolean handleModuleConfig() {
        Slot slot = this.getSlotUnderMouse();
        if (slot == null || !(slot.func_75211_c().func_77973_b() instanceof ItemModule) || slot.field_75222_d < 37 || slot.field_75222_d > 45) {
            return false;
        }
        MFLocator locator = MFLocator.moduleInRouter(this.router.func_174877_v(), slot.field_75222_d - 37);
        PacketHandler.NETWORK.sendToServer((Object)OpenGuiMessage.openModuleInRouter(locator));
        return true;
    }

    @Override
    public void sendToServer() {
        this.router.setRedstoneBehaviour((RouterRedstoneBehaviour)((Object)this.rrb.getState()));
        this.router.setEcoMode(this.reb.isToggled());
        PacketHandler.NETWORK.sendToServer((Object)new RouterSettingsMessage(this.router));
    }

    private class RouterEcoButton
    extends TexturedToggleButton {
        RouterEcoButton(int x, int y, int width, int height, boolean initialVal) {
            super(x, y, width, height, initialVal, GuiItemRouter.this);
        }

        @Override
        protected int getTextureX() {
            return this.isToggled() ? 96 : 80;
        }

        @Override
        protected int getTextureY() {
            return 16;
        }

        @Override
        public List<String> getTooltip() {
            return MiscUtil.wrapString(I18n.func_135052_a((String)("guiText.tooltip.eco." + this.isToggled()), (Object[])new Object[]{Float.valueOf((float)MRConfig.Common.Router.ecoTimeout / 20.0f), Float.valueOf((float)MRConfig.Common.Router.lowPowerTickRate / 20.0f)}));
        }
    }
}

