/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.ILeftClickableItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RandHelper;
import xreliquary.util.RegistryHelper;

public class PyromancerStaffItem
extends ToggleableItem
implements ILeftClickableItem {
    private static final String QUANTITY_TAG = "Quantity";
    private static final String BLAZE_MODE = "blaze";
    private static final String BLAZE_CHARGES_TAG = "blaze";
    private static final String ITEMS_TAG = "Items";
    private static final String CHARGE_MODE = "charge";
    private static final String ERUPTION_MODE = "eruption";

    public PyromancerStaffItem() {
        super("pyromancer_staff", new Item.Properties().func_200917_a(1));
    }

    public void func_77663_a(ItemStack stack, World world, Entity e, int i, boolean f) {
        if (!(e instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)e;
        this.doFireballAbsorbEffect(stack, player);
        if (!this.isEnabled(stack)) {
            this.doExtinguishEffect(player);
        } else {
            this.scanForFireChargeAndBlazePowder(stack, player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack staff, @Nullable World world, List<ITextComponent> tooltip) {
        String charges = "0";
        String blaze = "0";
        CompoundNBT tagCompound = NBTHelper.getTag(staff);
        ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            Item containedItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            int quantity = tagItemData.func_74762_e(QUANTITY_TAG);
            if (containedItem == Items.field_151065_br) {
                blaze = Integer.toString(quantity);
                continue;
            }
            if (containedItem != Items.field_151059_bz) continue;
            charges = Integer.toString(quantity);
        }
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charges", (Object)charges, (Object)"blaze", (Object)blaze), tooltip);
        if (this.isEnabled(staff)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.RED + Items.field_151065_br.func_200295_i(new ItemStack((IItemProvider)Items.field_151065_br)).getString() + TextFormatting.WHITE + " & " + TextFormatting.RED + Items.field_151059_bz.func_200295_i(new ItemStack((IItemProvider)Items.field_151059_bz)).getString())), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 11;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public String getMode(ItemStack stack) {
        if (NBTHelper.getString("mode", stack).equals("")) {
            this.setMode(stack, "blaze");
        }
        return NBTHelper.getString("mode", stack);
    }

    private void setMode(ItemStack stack, String s) {
        NBTHelper.putString("mode", stack, s);
    }

    private void cycleMode(ItemStack stack) {
        if (this.getMode(stack).equals("blaze")) {
            this.setMode(stack, CHARGE_MODE);
        } else if (this.getMode(stack).equals(CHARGE_MODE)) {
            this.setMode(stack, ERUPTION_MODE);
        } else if (this.getMode(stack).equals(ERUPTION_MODE)) {
            this.setMode(stack, "flint_and_steel");
        } else {
            this.setMode(stack, "blaze");
        }
    }

    @Override
    public ActionResultType onLeftClickItem(ItemStack stack, LivingEntity entityLiving) {
        if (!entityLiving.func_225608_bj_()) {
            return ActionResultType.CONSUME;
        }
        if (entityLiving.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        this.cycleMode(stack);
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            super.func_77659_a(world, player, hand);
        } else if (this.getMode(stack).equals("blaze")) {
            if (player.field_82175_bq) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            player.func_184609_a(hand);
            this.shootBlazeFireball(player, stack);
        } else if (this.getMode(stack).equals(CHARGE_MODE)) {
            if (player.field_82175_bq) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            player.func_184609_a(hand);
            Vec3d lookVec = player.func_70040_Z();
            this.shootGhastFireball(player, stack, lookVec);
        } else {
            player.func_184598_c(hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private void shootGhastFireball(PlayerEntity player, ItemStack stack, Vec3d lookVec) {
        if (this.removeItemFromInternalStorage(stack, Items.field_151059_bz, this.getFireChargeCost(), player.field_70170_p.field_72995_K, player)) {
            player.field_70170_p.func_217378_a(player, 1016, new BlockPos((int)player.func_226277_ct_(), (int)player.func_226278_cu_(), (int)player.func_226281_cx_()), 0);
            FireballEntity fireball = new FireballEntity(player.field_70170_p, (LivingEntity)player, lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
            fireball.field_70232_b = lookVec.field_72450_a / 3.0;
            fireball.field_70233_c = lookVec.field_72448_b / 3.0;
            fireball.field_70230_d = lookVec.field_72449_c / 3.0;
            fireball.func_70107_b(fireball.func_226277_ct_() + lookVec.field_72450_a, player.func_226278_cu_() + (double)player.func_70047_e(), fireball.func_226281_cx_() + lookVec.field_72449_c);
            player.field_70170_p.func_217376_c((Entity)fireball);
        }
    }

    private void shootBlazeFireball(PlayerEntity player, ItemStack stack) {
        Vec3d lookVec = player.func_70040_Z();
        if (this.removeItemFromInternalStorage(stack, Items.field_151065_br, this.getBlazePowderCost(), player.field_70170_p.field_72995_K, player)) {
            player.field_70170_p.func_217378_a(player, 1018, new BlockPos((int)player.func_226277_ct_(), (int)player.func_226278_cu_(), (int)player.func_226281_cx_()), 0);
            SmallFireballEntity fireball = new SmallFireballEntity(player.field_70170_p, (LivingEntity)player, lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
            fireball.field_70232_b = lookVec.field_72450_a / 3.0;
            fireball.field_70233_c = lookVec.field_72448_b / 3.0;
            fireball.field_70230_d = lookVec.field_72449_c / 3.0;
            fireball.func_70107_b(fireball.func_226277_ct_() + lookVec.field_72450_a, player.func_226278_cu_() + (double)player.func_70047_e(), fireball.func_226281_cx_() + lookVec.field_72449_c);
            player.field_70170_p.func_217376_c((Entity)fireball);
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        PlayerEntity player;
        RayTraceResult rayTraceResult;
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        if (this.getMode(stack).equals(ERUPTION_MODE) && (rayTraceResult = (player = (PlayerEntity)entity).func_213324_a(12.0, 1.0f, true)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            --count;
            count = this.func_77626_a(stack) - count;
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
            this.doEruptionAuxEffects(player, blockRayTraceResult.func_216350_a().func_177958_n(), blockRayTraceResult.func_216350_a().func_177956_o(), blockRayTraceResult.func_216350_a().func_177952_p());
            if (count % 10 == 0 && this.removeItemFromInternalStorage(stack, Items.field_151065_br, this.getBlazePowderCost(), player.field_70170_p.field_72995_K, player)) {
                this.doEruptionEffect(player, blockRayTraceResult.func_216350_a().func_177958_n(), blockRayTraceResult.func_216350_a().func_177956_o(), blockRayTraceResult.func_216350_a().func_177952_p());
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Direction face = context.func_196000_l();
        World world = context.func_195991_k();
        if (player == null) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        if (this.getMode(stack).equals("flint_and_steel")) {
            BlockPos placeFireAt = context.func_195995_a().func_177972_a(face);
            if (!player.func_175151_a(placeFireAt, face, stack)) {
                return ActionResultType.PASS;
            }
            if (world.func_175623_d(placeFireAt)) {
                world.func_184134_a((double)placeFireAt.func_177958_n() + 0.5, (double)placeFireAt.func_177956_o() + 0.5, (double)placeFireAt.func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f, false);
                world.func_175656_a(placeFireAt, Blocks.field_150480_ab.func_176223_P());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void doEruptionAuxEffects(PlayerEntity player, int soundX, int soundY, int soundZ) {
        double randZ;
        double randX;
        int particleCount;
        player.field_70170_p.func_184134_a((double)soundX + 0.5, (double)soundY + 0.5, (double)soundZ + 0.5, SoundEvents.field_187557_bK, SoundCategory.NEUTRAL, 0.2f, 0.03f + 0.07f * field_77697_d.nextFloat(), false);
        for (particleCount = 0; particleCount < 2; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 5.0;
            randZ = (double)soundZ + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 5.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, randX, (double)soundY + 1.0, randZ, 0.0, 0.0, 0.0);
        }
        for (particleCount = 0; particleCount < 4; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 5.0 / 2.0;
            randZ = (double)soundZ + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 5.0 / 2.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, randX, (double)soundY + 1.0, randZ, 0.0, 0.0, 0.0);
        }
        for (particleCount = 0; particleCount < 6; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 5.0;
            randZ = (double)soundZ + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 5.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, randX, (double)soundY + 1.0, randZ, player.field_70170_p.field_73012_v.nextGaussian() * 0.2, player.field_70170_p.field_73012_v.nextGaussian() * 0.2, player.field_70170_p.field_73012_v.nextGaussian() * 0.2);
        }
        for (particleCount = 0; particleCount < 8; ++particleCount) {
            randX = (double)soundX + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 5.0 / 2.0;
            randZ = (double)soundZ + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 5.0 / 2.0;
            if (!(Math.abs(randX - ((double)soundX + 0.5)) < 4.0) || !(Math.abs(randZ - ((double)soundZ + 0.5)) < 4.0)) continue;
            player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, randX, (double)soundY + 1.0, randZ, player.field_70170_p.field_73012_v.nextGaussian() * 0.2, player.field_70170_p.field_73012_v.nextGaussian() * 0.2, player.field_70170_p.field_73012_v.nextGaussian() * 0.2);
        }
    }

    private void doEruptionEffect(PlayerEntity player, int x, int y, int z) {
        double lowerX = (double)x - 5.0 + 0.5;
        double lowerZ = (double)z - 5.0 + 0.5;
        double upperX = (double)x + 5.0 + 0.5;
        double upperY = (double)y + 5.0;
        double upperZ = (double)z + 5.0 + 0.5;
        List entities = player.field_70170_p.func_217357_a(MobEntity.class, new AxisAlignedBB(lowerX, (double)y, lowerZ, upperX, upperY, upperZ));
        entities.stream().filter(e -> !e.func_70028_i((Entity)player)).forEach(e -> {
            e.func_70015_d(40);
            if (!e.func_70045_F()) {
                e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 4.0f);
            }
        });
    }

    private void scanForFireChargeAndBlazePowder(ItemStack staff, PlayerEntity player) {
        ArrayList<ItemStack> absorbItems = new ArrayList<ItemStack>();
        absorbItems.add(new ItemStack((IItemProvider)Items.field_151059_bz));
        absorbItems.add(new ItemStack((IItemProvider)Items.field_151065_br));
        absorbItems.stream().filter(absorbItem -> !this.isInternalStorageFullOfItem(staff, absorbItem.func_77973_b()) && InventoryHelper.consumeItem(absorbItem, player)).forEach(absorbItem -> this.addItemToInternalStorage(staff, absorbItem.func_77973_b(), false));
    }

    private void addItemToInternalStorage(ItemStack stack, Item item, boolean isAbsorb) {
        int quantityIncrease = item == Items.field_151059_bz ? (isAbsorb ? this.getGhastAbsorbWorth() : this.getFireChargeWorth()) : (isAbsorb ? this.getBlazeAbsorbWorth() : this.getBlazePowderWorth());
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
        boolean added = false;
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            if (!itemName.equals(RegistryHelper.getItemRegistryName(item))) continue;
            int quantity = tagItemData.func_74762_e(QUANTITY_TAG);
            tagItemData.func_74768_a(QUANTITY_TAG, quantity + quantityIncrease);
            added = true;
        }
        if (!added) {
            CompoundNBT newTagData = new CompoundNBT();
            newTagData.func_74778_a("Name", RegistryHelper.getItemRegistryName(item));
            newTagData.func_74768_a(QUANTITY_TAG, quantityIncrease);
            tagList.add((Object)newTagData);
        }
        tagCompound.func_218657_a(ITEMS_TAG, (INBT)tagList);
        stack.func_77982_d(tagCompound);
    }

    private boolean removeItemFromInternalStorage(ItemStack stack, Item item, int cost, boolean simulate, PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        if (this.hasItemInInternalStorage(stack, item, cost)) {
            CompoundNBT tagCompound = NBTHelper.getTag(stack);
            ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
            ListNBT replacementTagList = new ListNBT();
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                if (itemName.equals(RegistryHelper.getItemRegistryName(item))) {
                    int quantity = tagItemData.func_74762_e(QUANTITY_TAG);
                    if (!simulate) {
                        tagItemData.func_74768_a(QUANTITY_TAG, quantity - cost);
                    }
                }
                replacementTagList.add((Object)tagItemData);
            }
            tagCompound.func_218657_a(ITEMS_TAG, (INBT)replacementTagList);
            stack.func_77982_d(tagCompound);
            return true;
        }
        return false;
    }

    private boolean hasItemInInternalStorage(ItemStack stack, Item item, int cost) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        if (tagCompound.isEmpty()) {
            tagCompound.func_218657_a(ITEMS_TAG, (INBT)new ListNBT());
            return false;
        }
        ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            if (!itemName.equals(RegistryHelper.getItemRegistryName(item))) continue;
            int quantity = tagItemData.func_74762_e(QUANTITY_TAG);
            return quantity >= cost;
        }
        return false;
    }

    private boolean isInternalStorageFullOfItem(ItemStack stack, Item item) {
        int quantityLimit;
        int n = quantityLimit = item == Items.field_151059_bz ? this.getFireChargeLimit() : this.getBlazePowderLimit();
        if (this.hasItemInInternalStorage(stack, item, 1)) {
            CompoundNBT tagCompound = NBTHelper.getTag(stack);
            ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                if (!itemName.equals(RegistryHelper.getItemRegistryName(item))) continue;
                int quantity = tagItemData.func_74762_e(QUANTITY_TAG);
                return quantity >= quantityLimit;
            }
        }
        return false;
    }

    public int getInternalStorageItemCount(ItemStack staff, Item item) {
        CompoundNBT tagCompound = NBTHelper.getTag(staff);
        ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagItemData = tagList.func_150305_b(i);
            String itemName = tagItemData.func_74779_i("Name");
            if (!itemName.equals(RegistryHelper.getItemRegistryName(item))) continue;
            return tagItemData.func_74762_e(QUANTITY_TAG);
        }
        return 0;
    }

    private int getFireChargeWorth() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.fireChargeWorth.get();
    }

    private int getFireChargeCost() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.fireChargeCost.get();
    }

    private int getFireChargeLimit() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.fireChargeLimit.get();
    }

    private int getBlazePowderWorth() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.blazePowderWorth.get();
    }

    private int getBlazePowderCost() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.blazePowderCost.get();
    }

    private int getBlazePowderLimit() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.blazePowderLimit.get();
    }

    private int getBlazeAbsorbWorth() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.blazeAbsorbWorth.get();
    }

    private int getGhastAbsorbWorth() {
        return (Integer)Settings.COMMON.items.pyromancerStaff.ghastAbsorbWorth.get();
    }

    private void doExtinguishEffect(PlayerEntity player) {
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
        int x = (int)Math.floor(player.func_226277_ct_());
        int y = (int)Math.floor(player.func_226278_cu_());
        int z = (int)Math.floor(player.func_226281_cx_());
        for (int xOff = -3; xOff <= 3; ++xOff) {
            for (int yOff = -3; yOff <= 3; ++yOff) {
                for (int zOff = -3; zOff <= 3; ++zOff) {
                    Block block = player.field_70170_p.func_180495_p(new BlockPos(x + xOff, y + yOff, z + zOff)).func_177230_c();
                    if (block != Blocks.field_150480_ab) continue;
                    player.field_70170_p.func_175656_a(new BlockPos(x + xOff, y + yOff, z + zOff), Blocks.field_150350_a.func_176223_P());
                    player.field_70170_p.func_184134_a((double)(x + xOff) + 0.5, (double)(y + yOff) + 0.5, (double)(z + zOff) + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.8f, false);
                }
            }
        }
    }

    private void doFireballAbsorbEffect(ItemStack stack, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        this.absorbGhastFireballs(stack, player);
        this.absorbBlazeFireballs(stack, player);
    }

    private void absorbBlazeFireballs(ItemStack stack, PlayerEntity player) {
        List blazeFireballs = player.field_70170_p.func_217357_a(SmallFireballEntity.class, new AxisAlignedBB(player.func_226277_ct_() - 3.0, player.func_226278_cu_() - 3.0, player.func_226281_cx_() - 3.0, player.func_226277_ct_() + 3.0, player.func_226278_cu_() + 3.0, player.func_226281_cx_() + 3.0));
        for (SmallFireballEntity fireball : blazeFireballs) {
            if (fireball.field_70235_a == player) continue;
            for (int particles = 0; particles < 4; ++particles) {
                player.field_70170_p.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, fireball.func_226277_ct_(), fireball.func_226278_cu_(), fireball.func_226281_cx_(), 0.0, 1.0, 1.0);
            }
            player.field_70170_p.func_184134_a(fireball.func_226277_ct_(), fireball.func_226278_cu_(), fireball.func_226281_cx_(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.8f, false);
            if (!this.isInternalStorageFullOfItem(stack, Items.field_151065_br) && InventoryHelper.consumeItem(new ItemStack((IItemProvider)Items.field_151065_br), player)) {
                this.addItemToInternalStorage(stack, Items.field_151065_br, true);
            }
            fireball.func_70106_y();
        }
    }

    private void absorbGhastFireballs(ItemStack stack, PlayerEntity player) {
        List ghastFireballs = player.field_70170_p.func_217357_a(FireballEntity.class, new AxisAlignedBB(player.func_226277_ct_() - 5.0, player.func_226278_cu_() - 5.0, player.func_226281_cx_() - 5.0, player.func_226277_ct_() + 5.0, player.func_226278_cu_() + 5.0, player.func_226281_cx_() + 5.0));
        for (FireballEntity fireball : ghastFireballs) {
            if (fireball.field_70235_a == player || !(player.func_70032_d((Entity)fireball) < 4.0f)) continue;
            if (!this.isInternalStorageFullOfItem(stack, Items.field_151059_bz) && InventoryHelper.consumeItem(new ItemStack((IItemProvider)Items.field_151059_bz), player)) {
                this.addItemToInternalStorage(stack, Items.field_151059_bz, true);
                player.field_70170_p.func_184134_a(fireball.func_226277_ct_(), fireball.func_226278_cu_(), fireball.func_226281_cx_(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.8f, false);
            }
            fireball.func_70106_y();
        }
    }
}

