/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import xreliquary.common.gui.ContainerMobCharmBelt;
import xreliquary.items.ItemBase;
import xreliquary.items.MobCharmItem;
import xreliquary.items.util.IBaubleItem;
import xreliquary.reference.Settings;

public class MobCharmBeltItem
extends ItemBase
implements IBaubleItem {
    private static final String SLOTS_TAG = "Slots";

    public MobCharmBeltItem() {
        super("mob_charm_belt", new Item.Properties().func_200917_a(1));
    }

    @Override
    public IBaubleItem.Type getBaubleType() {
        return IBaubleItem.Type.BELT;
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
    }

    @Override
    public void onEquipped(String identifier, LivingEntity player) {
        if (player.field_70170_p.field_72995_K) {
            player.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_213453_ef()) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((w, p, pl) -> new ContainerMobCharmBelt(w, p, stack), stack.func_200301_q()), buf -> buf.writeBoolean(hand == Hand.MAIN_HAND));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ItemStack getMobCharmInSlot(ItemStack belt, int slotIndex) {
        CompoundNBT nbt = belt.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(SLOTS_TAG)) {
            return ItemStack.field_190927_a;
        }
        ListNBT mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        if (mobCharms.size() <= slotIndex) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)mobCharms.get(slotIndex)));
    }

    public void putMobCharmInSlot(ItemStack belt, int slotIndex, ItemStack mobCharm) {
        ListNBT mobCharms;
        if (mobCharm.func_190926_b()) {
            this.removeMobCharmInSlot(belt, slotIndex);
            return;
        }
        CompoundNBT mobCharmNbt = mobCharm.func_77955_b(new CompoundNBT());
        CompoundNBT nbt = belt.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            mobCharms = new ListNBT();
        } else {
            mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        }
        if (mobCharms.size() < slotIndex) {
            return;
        }
        if (mobCharms.size() == slotIndex) {
            mobCharms.add((Object)mobCharmNbt);
        } else {
            mobCharms.set(slotIndex, (INBT)mobCharmNbt);
        }
        nbt.func_218657_a(SLOTS_TAG, (INBT)mobCharms);
        belt.func_77982_d(nbt);
    }

    public void removeMobCharmInSlot(ItemStack belt, int slotIndex) {
        CompoundNBT nbt = belt.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(SLOTS_TAG)) {
            return;
        }
        ListNBT mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        if (mobCharms.size() <= slotIndex) {
            return;
        }
        mobCharms.remove(slotIndex);
    }

    public int getCharmCount(ItemStack belt) {
        CompoundNBT nbt = belt.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        ListNBT mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        return mobCharms.size();
    }

    public boolean hasCharm(ItemStack belt, String entityRegistryName) {
        CompoundNBT nbt = belt.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(SLOTS_TAG)) {
            return false;
        }
        ListNBT mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        for (int i = mobCharms.size() - 1; i >= 0; --i) {
            ItemStack charmStack = ItemStack.func_199557_a((CompoundNBT)mobCharms.func_150305_b(i));
            if (!MobCharmItem.getEntityRegistryName(charmStack).equals(entityRegistryName)) continue;
            return true;
        }
        return false;
    }

    ItemStack damageCharm(PlayerEntity player, ItemStack belt, String entityRegistryName) {
        CompoundNBT nbt = belt.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(SLOTS_TAG)) {
            return ItemStack.field_190927_a;
        }
        ListNBT mobCharms = nbt.func_150295_c(SLOTS_TAG, 10);
        for (int i = mobCharms.size() - 1; i >= 0; --i) {
            ItemStack charmStack = ItemStack.func_199557_a((CompoundNBT)mobCharms.func_150305_b(i));
            if (!MobCharmItem.isCharmFor(charmStack, entityRegistryName)) continue;
            charmStack.func_222118_a(((Integer)Settings.COMMON.items.mobCharm.damagePerKill.get()).intValue(), (LivingEntity)player, p -> p.func_213361_c(EquipmentSlotType.CHEST));
            if (charmStack.func_190926_b()) {
                this.removeMobCharmInSlot(belt, i);
                return ItemStack.field_190927_a;
            }
            mobCharms.set(i, (INBT)charmStack.func_77955_b(new CompoundNBT()));
            return charmStack;
        }
        return ItemStack.field_190927_a;
    }
}

