/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.page;

import com.terraforged.mod.TerraWorld;
import com.terraforged.mod.gui.OverlayScreen;
import com.terraforged.mod.gui.element.TerraTextInput;
import com.terraforged.mod.gui.page.BasePage;
import com.terraforged.mod.gui.page.Page;
import com.terraforged.mod.settings.TerraSettings;
import com.terraforged.mod.util.nbt.NBTHelper;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldType;
import net.minecraftforge.registries.ForgeRegistries;

public class DimensionsPage
extends BasePage {
    private final TerraSettings settings;
    private final CompoundNBT dimensionSettings;

    public DimensionsPage(TerraSettings settings) {
        this.settings = settings;
        this.dimensionSettings = NBTHelper.serialize(settings.dimensions);
        CompoundNBT generators = this.dimensionSettings.func_74775_l("dimensionGenerators").func_74775_l("value");
        for (String name : generators.func_150296_c()) {
            CompoundNBT setting = generators.func_74775_l(name);
            setting.func_218657_a("#options", (INBT)DimensionsPage.getWorldTypes());
        }
    }

    @Override
    public String getTitle() {
        return "Dimension Settings";
    }

    @Override
    public void save() {
        NBTHelper.deserialize(this.dimensionSettings, this.settings.dimensions);
    }

    @Override
    public void init(OverlayScreen parent) {
        Page.Column left = this.getColumn(0);
        this.addElements(left.left, left.top, left, this.dimensionSettings, true, left.scrollPane::addButton, this::update);
    }

    @Override
    public void onAddWidget(Widget widget) {
        if (widget instanceof TerraTextInput) {
            TerraTextInput input = (TerraTextInput)widget;
            input.setColorValidator(string -> ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(string)));
        }
    }

    private static ListNBT getWorldTypes() {
        ListNBT options = new ListNBT();
        for (WorldType type : WorldType.field_77139_a) {
            if (type == null || type.func_82747_f() >= 1 && type.func_82747_f() <= 6 || type.func_82747_f() == 8 || TerraWorld.isTerraType(type)) continue;
            options.add((Object)StringNBT.func_229705_a_((String)type.func_211888_a()));
        }
        return options;
    }
}

