/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.element;

import com.terraforged.mod.gui.element.Element;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.client.gui.widget.Slider;

public abstract class TerraSlider
extends Slider
implements Slider.ISlider,
Element {
    private final CompoundNBT value;
    private final List<String> tooltip;
    private Runnable callback = () -> {};

    public TerraSlider(String prefix, CompoundNBT value, boolean decimal) {
        super(0, 0, 100, 20, prefix, "", (double)value.func_74760_g("#min"), (double)value.func_74760_g("#max"), 0.0, decimal, true, b -> {});
        this.value = value;
        this.parent = this;
        this.tooltip = Element.readTooltip(value);
    }

    public TerraSlider callback(Runnable callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    public void onChangeSliderValue(Slider slider) {
        this.onChange(slider, this.value);
    }

    public void onRelease(double mouseX, double mouseY) {
        if (this.dragging) {
            this.callback.run();
        }
        super.onRelease(mouseX, mouseY);
    }

    protected abstract void onChange(Slider var1, CompoundNBT var2);

    public static class Float
    extends TerraSlider {
        public Float(String prefix, CompoundNBT value) {
            super(prefix, value, true);
            this.precision = 3;
            this.setValue(value.func_74760_g("value"));
            this.updateSlider();
        }

        @Override
        protected void onChange(Slider slider, CompoundNBT value) {
            int i = (int)(slider.getValue() * 1000.0);
            float f = (float)i / 1000.0f;
            value.func_74776_a("value", f);
        }
    }

    public static class Int
    extends TerraSlider {
        public Int(String prefix, CompoundNBT value) {
            super(prefix, value, false);
            this.setValue(value.func_74762_e("value"));
            this.updateSlider();
        }

        @Override
        protected void onChange(Slider slider, CompoundNBT value) {
            value.func_74768_a("value", slider.getValueInt());
        }
    }
}

