/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.supermultidrills.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.supermultidrills.SuperMultiDrills;
import net.silentchaos512.supermultidrills.capability.EnergyStorageItemImpl;
import net.silentchaos512.supermultidrills.util.TextUtil;

public class DrillBatteryItem
extends Item {
    private final int capacity;
    private final int transferRate;

    public DrillBatteryItem(int capacity, int transferRate) {
        super(new Item.Properties().func_200916_a(SuperMultiDrills.ITEM_GROUP).func_200917_a(1));
        this.capacity = capacity;
        this.transferRate = transferRate;
    }

    private static float getChargeRatio(ItemStack stack) {
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
        }
        return 0.0f;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilityEnergy.ENERGY) {
                    return LazyOptional.of(() -> new EnergyStorageItemImpl(stack, DrillBatteryItem.this.capacity, DrillBatteryItem.this.transferRate, DrillBatteryItem.this.transferRate)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TextUtil.addEnergyInfo(stack, tooltip);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack full = new ItemStack((IItemProvider)this);
            full.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> {
                if (e instanceof EnergyStorageItemImpl) {
                    ((EnergyStorageItemImpl)((Object)e)).setEnergyStored(e.getMaxEnergyStored());
                }
            });
            items.add((Object)full);
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - DrillBatteryItem.getChargeRatio(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)((1.0f + DrillBatteryItem.getChargeRatio(stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

