/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public abstract class AbstractBigMushroomFeature
extends Feature<BigMushroomFeatureConfig> {
    public AbstractBigMushroomFeature(Function<Dynamic<?>, ? extends BigMushroomFeatureConfig> p_i225795_1_) {
        super(p_i225795_1_);
    }

    protected void func_227210_a_(IWorld p_227210_1_, Random p_227210_2_, BlockPos p_227210_3_, BigMushroomFeatureConfig p_227210_4_, int p_227210_5_, BlockPos.Mutable p_227210_6_) {
        for (int i = 0; i < p_227210_5_; ++i) {
            p_227210_6_.func_189533_g((Vec3i)p_227210_3_).func_189534_c(Direction.UP, i);
            if (!p_227210_1_.func_180495_p((BlockPos)p_227210_6_).canBeReplacedByLogs(p_227210_1_, (BlockPos)p_227210_6_)) continue;
            this.func_202278_a((IWorldWriter)p_227210_1_, (BlockPos)p_227210_6_, p_227210_4_.field_227273_b_.func_225574_a_(p_227210_2_, p_227210_3_));
        }
    }

    protected int func_227211_a_(Random p_227211_1_) {
        int i = p_227211_1_.nextInt(3) + 4;
        if (p_227211_1_.nextInt(12) == 0) {
            i *= 2;
        }
        return i;
    }

    protected boolean func_227209_a_(IWorld p_227209_1_, BlockPos p_227209_2_, int p_227209_3_, BlockPos.Mutable p_227209_4_, BigMushroomFeatureConfig p_227209_5_) {
        int i = p_227209_2_.func_177956_o();
        if (i >= 1 && i + p_227209_3_ + 1 < p_227209_1_.getMaxHeight()) {
            Block block = p_227209_1_.func_180495_p(p_227209_2_.func_177977_b()).func_177230_c();
            if (!AbstractBigMushroomFeature.func_227250_b_(block)) {
                return false;
            }
            for (int j = 0; j <= p_227209_3_; ++j) {
                int k = this.func_225563_a_(-1, -1, p_227209_5_.field_227274_c_, j);
                for (int l = -k; l <= k; ++l) {
                    for (int i1 = -k; i1 <= k; ++i1) {
                        BlockState blockstate = p_227209_1_.func_180495_p((BlockPos)p_227209_4_.func_189533_g((Vec3i)p_227209_2_).func_196234_d(l, j, i1));
                        if (blockstate.isAir((IBlockReader)((Object)p_227209_1_), (BlockPos)p_227209_4_) || blockstate.func_203425_a(BlockTags.field_206952_E)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean func_212245_a(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BigMushroomFeatureConfig config) {
        BlockPos.Mutable blockpos$mutable;
        int i = this.func_227211_a_(rand);
        if (!this.func_227209_a_(worldIn, pos, i, blockpos$mutable = new BlockPos.Mutable(), config)) {
            return false;
        }
        this.func_225564_a_(worldIn, rand, pos, i, blockpos$mutable, config);
        this.func_227210_a_(worldIn, rand, pos, config, i, blockpos$mutable);
        return true;
    }

    protected abstract int func_225563_a_(int var1, int var2, int var3, int var4);

    protected abstract void func_225564_a_(IWorld var1, Random var2, BlockPos var3, int var4, BlockPos.Mutable var5, BigMushroomFeatureConfig var6);
}

