/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public abstract class ChunkGenerator<C extends GenerationSettings> {
    protected final IWorld field_222540_a;
    protected final long field_222541_b;
    protected final BiomeProvider field_222542_c;
    protected final C field_222543_d;

    public ChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn, C generationSettingsIn) {
        this.field_222540_a = worldIn;
        this.field_222541_b = worldIn.func_72905_C();
        this.field_222542_c = biomeProviderIn;
        this.field_222543_d = generationSettingsIn;
    }

    public void func_222539_a(IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        ((ChunkPrimer)chunkIn).func_225548_a_(new BiomeContainer(chunkpos, this.field_222542_c));
    }

    protected Biome func_225552_a_(BiomeManager biomeManagerIn, BlockPos posIn) {
        return biomeManagerIn.func_226836_a_(posIn);
    }

    public void func_225550_a_(BiomeManager p_225550_1_, IChunk p_225550_2_, GenerationStage.Carving p_225550_3_) {
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        int i = 8;
        ChunkPos chunkpos = p_225550_2_.func_76632_l();
        int j = chunkpos.field_77276_a;
        int k = chunkpos.field_77275_b;
        Biome biome = this.func_225552_a_(p_225550_1_, chunkpos.func_206849_h());
        BitSet bitset = p_225550_2_.func_205749_a(p_225550_3_);
        for (int l = j - 8; l <= j + 8; ++l) {
            for (int i1 = k - 8; i1 <= k + 8; ++i1) {
                List<ConfiguredCarver<?>> list = biome.func_203603_a(p_225550_3_);
                ListIterator<ConfiguredCarver<?>> listiterator = list.listIterator();
                while (listiterator.hasNext()) {
                    int j1 = listiterator.nextIndex();
                    ConfiguredCarver<?> configuredcarver = listiterator.next();
                    sharedseedrandom.func_202425_c(this.field_222541_b + (long)j1, l, i1);
                    if (!configuredcarver.func_222730_a((Random)sharedseedrandom, l, i1)) continue;
                    configuredcarver.func_227207_a_(p_225550_2_, p_227059_2_ -> this.func_225552_a_(p_225550_1_, (BlockPos)p_227059_2_), (Random)sharedseedrandom, this.func_222530_f(), l, i1, j, k, bitset);
                }
            }
        }
    }

    @Nullable
    public BlockPos func_211403_a(World worldIn, String name, BlockPos pos, int radius, boolean skipExistingChunks) {
        Structure structure = (Structure)Feature.field_202300_at.get((Object)name.toLowerCase(Locale.ROOT));
        return structure != null ? structure.func_211405_a(worldIn, this, pos, radius, skipExistingChunks) : null;
    }

    public void func_202092_b(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        int k = i * 16;
        int l = j * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        Biome biome = this.func_225552_a_(region.func_225523_d_(), blockpos.func_177982_a(8, 8, 8));
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        long i1 = sharedseedrandom.func_202424_a(region.func_72905_C(), k, l);
        for (GenerationStage.Decoration generationstage$decoration : GenerationStage.Decoration.values()) {
            try {
                biome.func_203608_a(generationstage$decoration, this, region, i1, sharedseedrandom, blockpos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a(exception, "Biome decoration");
                crashreport.func_85058_a("Generation").func_71507_a("CenterX", i).func_71507_a("CenterZ", j).func_71507_a("Step", generationstage$decoration).func_71507_a("Seed", i1).func_71507_a("Biome", Registry.field_212624_m.func_177774_c(biome));
                throw new ReportedException(crashreport);
            }
        }
    }

    public abstract void func_225551_a_(WorldGenRegion var1, IChunk var2);

    public void func_202093_c(WorldGenRegion region) {
    }

    public C func_201496_a_() {
        return this.field_222543_d;
    }

    public abstract int func_205470_d();

    public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
    }

    public boolean func_202094_a(Biome biomeIn, Structure<? extends IFeatureConfig> structureIn) {
        return biomeIn.func_201858_a(structureIn);
    }

    @Nullable
    public <C extends IFeatureConfig> C func_202087_b(Biome biomeIn, Structure<C> structureIn) {
        return biomeIn.func_201857_b(structureIn);
    }

    public BiomeProvider func_202090_b() {
        return this.field_222542_c;
    }

    public long func_202089_c() {
        return this.field_222541_b;
    }

    public int func_207511_e() {
        return 256;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        return this.field_222540_a.func_226691_t_(pos).func_76747_a(creatureType);
    }

    public void func_227058_a_(BiomeManager p_227058_1_, IChunk p_227058_2_, ChunkGenerator<?> p_227058_3_, TemplateManager p_227058_4_) {
        for (Structure structure : Feature.field_202300_at.values()) {
            if (!p_227058_3_.func_202090_b().func_205004_a(structure)) continue;
            StructureStart structurestart = p_227058_2_.func_201585_a(structure.func_143025_a());
            int i = structurestart != null ? structurestart.func_227457_j_() : 0;
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
            ChunkPos chunkpos = p_227058_2_.func_76632_l();
            StructureStart structurestart1 = StructureStart.field_214630_a;
            Biome biome = p_227058_1_.func_226836_a_(new BlockPos(chunkpos.func_180334_c() + 9, 0, chunkpos.func_180333_d() + 9));
            if (structure.func_225558_a_(p_227058_1_, p_227058_3_, (Random)sharedseedrandom, chunkpos.field_77276_a, chunkpos.field_77275_b, biome)) {
                StructureStart structurestart2 = structure.func_214557_a().create(structure, chunkpos.field_77276_a, chunkpos.field_77275_b, MutableBoundingBox.func_78887_a(), i, p_227058_3_.func_202089_c());
                structurestart2.func_214625_a(this, p_227058_4_, chunkpos.field_77276_a, chunkpos.field_77275_b, biome);
                structurestart1 = structurestart2.func_75069_d() ? structurestart2 : StructureStart.field_214630_a;
            }
            p_227058_2_.func_201584_a(structure.func_143025_a(), structurestart1);
        }
    }

    public void func_222528_a(IWorld worldIn, IChunk chunkIn) {
        int i = 8;
        int j = chunkIn.func_76632_l().field_77276_a;
        int k = chunkIn.func_76632_l().field_77275_b;
        int l = j << 4;
        int i1 = k << 4;
        for (int j1 = j - 8; j1 <= j + 8; ++j1) {
            for (int k1 = k - 8; k1 <= k + 8; ++k1) {
                long l1 = ChunkPos.func_77272_a((int)j1, (int)k1);
                for (Map.Entry<String, StructureStart> entry : worldIn.func_212866_a_(j1, k1).func_201609_c().entrySet()) {
                    StructureStart structurestart = entry.getValue();
                    if (structurestart == StructureStart.field_214630_a || !structurestart.func_75071_a().func_78885_a(l, i1, l + 15, i1 + 15)) continue;
                    chunkIn.func_201583_a(entry.getKey(), l1);
                    DebugPacketSender.func_218804_a((IWorld)worldIn, (StructureStart)structurestart);
                }
            }
        }
    }

    public abstract void func_222537_b(IWorld var1, IChunk var2);

    public int func_222530_f() {
        return this.field_222540_a.func_201675_m().getSeaLevel();
    }

    public abstract int func_222529_a(int var1, int var2, Heightmap.Type var3);

    public int func_222532_b(int p_222532_1_, int p_222532_2_, Heightmap.Type heightmapType) {
        return this.func_222529_a(p_222532_1_, p_222532_2_, heightmapType);
    }

    public int func_222531_c(int p_222531_1_, int p_222531_2_, Heightmap.Type heightmapType) {
        return this.func_222529_a(p_222531_1_, p_222531_2_, heightmapType) - 1;
    }
}

