/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.horse;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HorseEntity
extends AbstractHorseEntity {
    private static final UUID field_184786_bD = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataParameter<Integer> field_184789_bG = EntityDataManager.func_187226_a(HorseEntity.class, DataSerializers.field_187192_b);
    private static final String[] field_110268_bz = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};
    private static final String[] field_110269_bA = new String[]{"hwh", "hcr", "hch", "hbr", "hbl", "hgr", "hdb"};
    private static final String[] field_110291_bB = new String[]{null, "textures/entity/horse/horse_markings_white.png", "textures/entity/horse/horse_markings_whitefield.png", "textures/entity/horse/horse_markings_whitedots.png", "textures/entity/horse/horse_markings_blackdots.png"};
    private static final String[] field_110292_bC = new String[]{"", "wo_", "wmo", "wdo", "bdo"};
    @Nullable
    private String field_110286_bQ;
    private final String[] field_110280_bR = new String[2];

    public HorseEntity(EntityType<? extends HorseEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184789_bG, 0);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.func_110202_bQ());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compound.func_218657_a("ArmorItem", this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    public ItemStack func_213803_dV() {
        return this.func_184582_a(EquipmentSlotType.CHEST);
    }

    private void func_213805_k(ItemStack p_213805_1_) {
        this.func_184201_a(EquipmentSlotType.CHEST, p_213805_1_);
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        ItemStack itemstack;
        super.func_70037_a(compound);
        this.func_110235_q(compound.func_74762_e("Variant"));
        if (compound.func_150297_b("ArmorItem", 10) && !(itemstack = ItemStack.func_199557_a(compound.func_74775_l("ArmorItem"))).func_190926_b() && this.func_190682_f(itemstack)) {
            this.field_110296_bG.func_70299_a(1, itemstack);
        }
        this.func_110232_cE();
    }

    public void func_110235_q(int variant) {
        this.field_70180_af.func_187227_b(field_184789_bG, variant);
        this.func_110230_cF();
    }

    public int func_110202_bQ() {
        return this.field_70180_af.func_187225_a(field_184789_bG);
    }

    private void func_110230_cF() {
        this.field_110286_bQ = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_110247_cG() {
        int i = this.func_110202_bQ();
        int j = (i & 0xFF) % 7;
        int k = ((i & 0xFF00) >> 8) % 5;
        this.field_110280_bR[0] = field_110268_bz[j];
        this.field_110280_bR[1] = field_110291_bB[k];
        this.field_110286_bQ = "horse/" + field_110269_bA[j] + field_110292_bC[k];
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_110264_co() {
        if (this.field_110286_bQ == null) {
            this.func_110247_cG();
        }
        return this.field_110286_bQ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String[] func_110212_cp() {
        if (this.field_110286_bQ == null) {
            this.func_110247_cG();
        }
        return this.field_110280_bR;
    }

    @Override
    protected void func_110232_cE() {
        super.func_110232_cE();
        this.func_213804_l(this.field_110296_bG.func_70301_a(1));
        this.func_184642_a(EquipmentSlotType.CHEST, 0.0f);
    }

    private void func_213804_l(ItemStack p_213804_1_) {
        this.func_213805_k(p_213804_1_);
        if (!this.field_70170_p.field_72995_K) {
            int i;
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(field_184786_bD);
            if (this.func_190682_f(p_213804_1_) && (i = ((HorseArmorItem)p_213804_1_.func_77973_b()).func_219977_e()) != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(field_184786_bD, "Horse armor bonus", (double)i, AttributeModifier.Operation.ADDITION).func_111168_a(false));
            }
        }
    }

    @Override
    public void func_76316_a(IInventory invBasic) {
        ItemStack itemstack = this.func_213803_dV();
        super.func_76316_a(invBasic);
        ItemStack itemstack1 = this.func_213803_dV();
        if (this.field_70173_aa > 20 && this.func_190682_f(itemstack1) && itemstack != itemstack1) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
        }
    }

    @Override
    protected void func_190680_a(SoundType p_190680_1_) {
        super.func_190680_a(p_190680_1_);
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_184185_a(SoundEvents.field_187705_cn, p_190680_1_.func_185843_a() * 0.6f, p_190680_1_.func_185847_b());
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.func_110267_cL());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110203_cN());
        this.func_110148_a(field_110271_bv).func_111128_a(this.func_110245_cM());
    }

    @Override
    public void func_70071_h_() {
        ItemStack stack;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.func_110230_cF();
        }
        if (this.func_190682_f(stack = this.field_110296_bG.func_70301_a(1))) {
            stack.onHorseArmorTick(this.field_70170_p, (MobEntity)((Object)this));
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187696_ck;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187708_co;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        super.func_184601_bQ(damageSourceIn);
        return SoundEvents.field_187717_cr;
    }

    @Override
    protected SoundEvent func_184785_dv() {
        super.func_184785_dv();
        return SoundEvents.field_187699_cl;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = !itemstack.func_190926_b();
        if (flag && itemstack.func_77973_b() instanceof SpawnEggItem) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && player.func_226563_dT_()) {
                this.func_110199_f(player);
                return true;
            }
            if (this.func_184207_aI()) {
                return super.func_184645_a(player, hand);
            }
        }
        if (flag) {
            boolean flag1;
            if (this.func_190678_b(player, itemstack)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack.func_111282_a(player, (LivingEntity)((Object)this), hand)) {
                return true;
            }
            if (!this.func_110248_bS()) {
                this.func_190687_dF();
                return true;
            }
            boolean bl2 = flag1 = !this.func_70631_g_() && !this.func_110257_ck() && itemstack.func_77973_b() == Items.field_151141_av;
            if (this.func_190682_f(itemstack) || flag1) {
                this.func_110199_f(player);
                return true;
            }
        }
        if (this.func_70631_g_()) {
            return super.func_184645_a(player, hand);
        }
        this.func_110237_h(player);
        return true;
    }

    @Override
    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof DonkeyEntity) && !(otherAnimal instanceof HorseEntity)) {
            return false;
        }
        return this.func_110200_cJ() && ((AbstractHorseEntity)otherAnimal).func_110200_cJ();
    }

    @Override
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        AbstractHorseEntity abstracthorseentity;
        if (ageable instanceof DonkeyEntity) {
            abstracthorseentity = (AbstractHorseEntity)EntityType.field_200779_S.func_200721_a(this.field_70170_p);
        } else {
            HorseEntity horseentity = (HorseEntity)ageable;
            abstracthorseentity = EntityType.field_200762_B.func_200721_a(this.field_70170_p);
            int j = this.field_70146_Z.nextInt(9);
            int i = j < 4 ? this.func_110202_bQ() & 0xFF : (j < 8 ? horseentity.func_110202_bQ() & 0xFF : this.field_70146_Z.nextInt(7));
            int k = this.field_70146_Z.nextInt(5);
            i = k < 2 ? (i |= this.func_110202_bQ() & 0xFF00) : (k < 4 ? (i |= horseentity.func_110202_bQ() & 0xFF00) : (i |= this.field_70146_Z.nextInt(5) << 8 & 0xFF00));
            ((HorseEntity)abstracthorseentity).func_110235_q(i);
        }
        this.func_190681_a(ageable, abstracthorseentity);
        return abstracthorseentity;
    }

    @Override
    public boolean func_190677_dK() {
        return true;
    }

    @Override
    public boolean func_190682_f(ItemStack stack) {
        return stack.func_77973_b() instanceof HorseArmorItem;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int i;
        if (spawnDataIn instanceof HorseData) {
            i = ((HorseData)((Object)spawnDataIn)).field_190885_a;
        } else {
            i = this.field_70146_Z.nextInt(7);
            spawnDataIn = new HorseData(i);
        }
        this.func_110235_q(i | this.field_70146_Z.nextInt(5) << 8);
        return super.func_213386_a(worldIn, difficultyIn, reason, (ILivingEntityData)spawnDataIn, dataTag);
    }

    public static class HorseData
    extends AgeableEntity.AgeableData {
        public final int field_190885_a;

        public HorseData(int variantIn) {
            this.field_190885_a = variantIn;
        }
    }
}

