/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstoneWireBlock
extends Block {
    public static final EnumProperty<RedstoneSide> field_176348_a = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> field_176347_b = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> field_176349_M = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> field_176350_N = BlockStateProperties.field_208162_O;
    public static final IntegerProperty field_176351_O = BlockStateProperties.field_208136_ak;
    public static final Map<Direction, EnumProperty<RedstoneSide>> field_196498_A = Maps.newEnumMap((Map)ImmutableMap.of((Object)((Object)Direction.NORTH), field_176348_a, (Object)((Object)Direction.EAST), field_176347_b, (Object)((Object)Direction.SOUTH), field_176349_M, (Object)((Object)Direction.WEST), field_176350_N));
    protected static final VoxelShape[] field_196499_B = new VoxelShape[]{Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 3.0, 13.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 3.0, 13.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 0.0, 13.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 13.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 0.0, 13.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 3.0, 16.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 3.0, 16.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 3.0, 16.0, 1.0, 16.0), Block.func_208617_a(3.0, 0.0, 0.0, 16.0, 1.0, 13.0), Block.func_208617_a(3.0, 0.0, 0.0, 16.0, 1.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 1.0, 13.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0)};
    private boolean field_150181_a = true;
    private final Set<BlockPos> field_150179_b = Sets.newHashSet();

    public RedstoneWireBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176348_a, (Comparable)RedstoneSide.NONE))).func_206870_a((IProperty)field_176347_b, (Comparable)RedstoneSide.NONE))).func_206870_a((IProperty)field_176349_M, (Comparable)RedstoneSide.NONE))).func_206870_a((IProperty)field_176350_N, (Comparable)RedstoneSide.NONE))).func_206870_a((IProperty)field_176351_O, Integer.valueOf(0))));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_196499_B[RedstoneWireBlock.func_185699_x(state)];
    }

    private static int func_185699_x(BlockState state) {
        boolean flag3;
        int i = 0;
        boolean flag = state.func_177229_b((IProperty)field_176348_a) != RedstoneSide.NONE;
        boolean flag1 = state.func_177229_b((IProperty)field_176347_b) != RedstoneSide.NONE;
        boolean flag2 = state.func_177229_b((IProperty)field_176349_M) != RedstoneSide.NONE;
        boolean bl = flag3 = state.func_177229_b((IProperty)field_176350_N) != RedstoneSide.NONE;
        if (flag || flag2 && !flag && !flag1 && !flag3) {
            i |= 1 << Direction.NORTH.func_176736_b();
        }
        if (flag1 || flag3 && !flag && !flag1 && !flag2) {
            i |= 1 << Direction.EAST.func_176736_b();
        }
        if (flag2 || flag && !flag1 && !flag2 && !flag3) {
            i |= 1 << Direction.SOUTH.func_176736_b();
        }
        if (flag3 || flag1 && !flag && !flag2 && !flag3) {
            i |= 1 << Direction.WEST.func_176736_b();
        }
        return i;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_176350_N, (Comparable)this.func_208074_a((IBlockReader)((Object)iblockreader), blockpos, Direction.WEST)))).func_206870_a((IProperty)field_176347_b, (Comparable)this.func_208074_a((IBlockReader)((Object)iblockreader), blockpos, Direction.EAST)))).func_206870_a((IProperty)field_176348_a, (Comparable)this.func_208074_a((IBlockReader)((Object)iblockreader), blockpos, Direction.NORTH)))).func_206870_a((IProperty)field_176349_M, (Comparable)this.func_208074_a((IBlockReader)((Object)iblockreader), blockpos, Direction.SOUTH)));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        return facing == Direction.UP ? (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)stateIn.func_206870_a((IProperty)field_176350_N, (Comparable)this.func_208074_a((IBlockReader)((Object)worldIn), currentPos, Direction.WEST)))).func_206870_a((IProperty)field_176347_b, (Comparable)this.func_208074_a((IBlockReader)((Object)worldIn), currentPos, Direction.EAST)))).func_206870_a((IProperty)field_176348_a, (Comparable)this.func_208074_a((IBlockReader)((Object)worldIn), currentPos, Direction.NORTH)))).func_206870_a((IProperty)field_176349_M, (Comparable)this.func_208074_a((IBlockReader)((Object)worldIn), currentPos, Direction.SOUTH))) : (BlockState)((Object)stateIn.func_206870_a((IProperty)field_196498_A.get((Object)facing), (Comparable)this.func_208074_a((IBlockReader)((Object)worldIn), currentPos, facing)));
    }

    @Override
    public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags) {
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((IProperty)field_196498_A.get((Object)direction));
                if (redstoneside == RedstoneSide.NONE || worldIn.func_180495_p((BlockPos)blockpos$pooledmutable.func_189533_g((Vec3i)pos).func_189536_c(direction)).func_177230_c() == this) continue;
                blockpos$pooledmutable.func_189536_c(Direction.DOWN);
                BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$pooledmutable);
                if (blockstate.func_177230_c() != Blocks.field_190976_dk) {
                    BlockPos blockpos = blockpos$pooledmutable.func_177972_a(direction.func_176734_d());
                    BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos), worldIn, (BlockPos)blockpos$pooledmutable, blockpos);
                    RedstoneWireBlock.func_196263_a(blockstate, blockstate1, worldIn, (BlockPos)blockpos$pooledmutable, flags);
                }
                blockpos$pooledmutable.func_189533_g((Vec3i)pos).func_189536_c(direction).func_189536_c(Direction.UP);
                BlockState blockstate3 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutable);
                if (blockstate3.func_177230_c() == Blocks.field_190976_dk) continue;
                BlockPos blockpos1 = blockpos$pooledmutable.func_177972_a(direction.func_176734_d());
                BlockState blockstate2 = blockstate3.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos1), worldIn, (BlockPos)blockpos$pooledmutable, blockpos1);
                RedstoneWireBlock.func_196263_a(blockstate3, blockstate2, worldIn, (BlockPos)blockpos$pooledmutable, flags);
            }
        }
    }

    private RedstoneSide func_208074_a(IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockPos blockpos = pos.func_177972_a(face);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        BlockPos blockpos1 = pos.func_177984_a();
        BlockState blockstate1 = worldIn.func_180495_p(blockpos1);
        if (!blockstate1.func_215686_e(worldIn, blockpos1)) {
            boolean flag;
            boolean bl = flag = blockstate.func_224755_d(worldIn, blockpos, Direction.UP) || blockstate.func_177230_c() == Blocks.field_150438_bZ;
            if (flag && RedstoneWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177984_a()), worldIn, blockpos.func_177984_a(), null)) {
                if (blockstate.func_224756_o(worldIn, blockpos)) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !RedstoneWireBlock.canConnectTo(blockstate, worldIn, blockpos, face) && (blockstate.func_215686_e(worldIn, blockpos) || !RedstoneWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177977_b()), worldIn, blockpos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)((Object)worldIn), blockpos, Direction.UP) || blockstate.func_177230_c() == Blocks.field_150438_bZ;
    }

    private BlockState func_176338_e(World worldIn, BlockPos pos, BlockState state) {
        state = this.func_212568_b(worldIn, pos, state);
        ArrayList list = Lists.newArrayList(this.field_150179_b);
        this.field_150179_b.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_195593_d(blockpos, this);
        }
        return state;
    }

    private BlockState func_212568_b(World worldIn, BlockPos pos, BlockState state) {
        int l;
        BlockState blockstate = state;
        int i = (Integer)state.func_177229_b((IProperty)field_176351_O);
        this.field_150181_a = false;
        int j = worldIn.func_175687_A(pos);
        this.field_150181_a = true;
        int k = 0;
        if (j < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(direction);
                BlockState blockstate1 = worldIn.func_180495_p(blockpos);
                k = this.func_212567_a(k, blockstate1);
                BlockPos blockpos1 = pos.func_177984_a();
                if (blockstate1.func_215686_e((IBlockReader)((Object)worldIn), blockpos) && !worldIn.func_180495_p(blockpos1).func_215686_e((IBlockReader)((Object)worldIn), blockpos1)) {
                    k = this.func_212567_a(k, worldIn.func_180495_p(blockpos.func_177984_a()));
                    continue;
                }
                if (blockstate1.func_215686_e((IBlockReader)((Object)worldIn), blockpos)) continue;
                k = this.func_212567_a(k, worldIn.func_180495_p(blockpos.func_177977_b()));
            }
        }
        if (j > (l = k - 1)) {
            l = j;
        }
        if (i != l) {
            state = (BlockState)((Object)state.func_206870_a((IProperty)field_176351_O, Integer.valueOf(l)));
            if (worldIn.func_180495_p(pos) == blockstate) {
                worldIn.func_180501_a(pos, state, 2);
            }
            this.field_150179_b.add(pos);
            for (Direction direction1 : Direction.values()) {
                this.field_150179_b.add(pos.func_177972_a(direction1));
            }
        }
        return state;
    }

    private void func_176344_d(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_195593_d(pos, this);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), this);
            }
        }
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K) {
            this.func_176338_e(worldIn, pos, state);
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.func_195593_d(pos.func_177972_a(direction), this);
            }
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                this.func_176344_d(worldIn, pos.func_177972_a(direction1));
            }
            for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(direction2);
                if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)((Object)worldIn), blockpos)) {
                    this.func_176344_d(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.func_176344_d(worldIn, blockpos.func_177977_b());
            }
        }
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (!worldIn.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(direction), this);
                }
                this.func_176338_e(worldIn, pos, state);
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.func_176344_d(worldIn, pos.func_177972_a(direction1));
                }
                for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                    BlockPos blockpos = pos.func_177972_a(direction2);
                    if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)((Object)worldIn), blockpos)) {
                        this.func_176344_d(worldIn, blockpos.func_177984_a());
                        continue;
                    }
                    this.func_176344_d(worldIn, blockpos.func_177977_b());
                }
            }
        }
    }

    private int func_212567_a(int existingSignal, BlockState neighbor) {
        if (neighbor.func_177230_c() != this) {
            return existingSignal;
        }
        int i = (Integer)neighbor.func_177229_b((IProperty)field_176351_O);
        return i > existingSignal ? i : existingSignal;
    }

    @Override
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            if (state.func_196955_c(worldIn, pos)) {
                this.func_176338_e(worldIn, pos, state);
            } else {
                RedstoneWireBlock.func_220075_c(state, worldIn, pos);
                worldIn.func_217377_a(pos, false);
            }
        }
    }

    @Override
    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return !this.field_150181_a ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    @Override
    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!this.field_150181_a) {
            return 0;
        }
        int i = (Integer)blockState.func_177229_b((IProperty)field_176351_O);
        if (i == 0) {
            return 0;
        }
        if (side == Direction.UP) {
            return i;
        }
        EnumSet<Direction> enumset = EnumSet.noneOf(Direction.class);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!this.func_176339_d(blockAccess, pos, direction)) continue;
            enumset.add(direction);
        }
        if (side.func_176740_k().func_176722_c() && enumset.isEmpty()) {
            return i;
        }
        return enumset.contains((Object)side) && !enumset.contains((Object)side.func_176735_f()) && !enumset.contains((Object)side.func_176746_e()) ? i : 0;
    }

    private boolean func_176339_d(IBlockReader worldIn, BlockPos pos, Direction side) {
        BlockPos blockpos = pos.func_177972_a(side);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        boolean flag = blockstate.func_215686_e(worldIn, blockpos);
        BlockPos blockpos1 = pos.func_177984_a();
        boolean flag1 = worldIn.func_180495_p(blockpos1).func_215686_e(worldIn, blockpos1);
        if (!flag1 && flag && RedstoneWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177984_a()), worldIn, blockpos.func_177984_a(), null)) {
            return true;
        }
        if (RedstoneWireBlock.canConnectTo(blockstate, worldIn, blockpos, side)) {
            return true;
        }
        if (blockstate.func_177230_c() == Blocks.field_196633_cV && ((Boolean)blockstate.func_177229_b((IProperty)RedstoneDiodeBlock.field_196348_c)).booleanValue() && blockstate.func_177229_b((IProperty)RedstoneDiodeBlock.field_185512_D) == side) {
            return true;
        }
        return !flag && RedstoneWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177977_b()), worldIn, blockpos.func_177977_b(), null);
    }

    protected static boolean canConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150488_af) {
            return true;
        }
        if (blockState.func_177230_c() == Blocks.field_196633_cV) {
            Direction direction = (Direction)((Object)blockState.func_177229_b((IProperty)RepeaterBlock.field_185512_D));
            return direction == side || direction.func_176734_d() == side;
        }
        if (Blocks.field_190976_dk == blockState.func_177230_c()) {
            return side == blockState.func_177229_b((IProperty)ObserverBlock.field_176387_N);
        }
        return blockState.canConnectRedstone(world, pos, side) && side != null;
    }

    @Override
    public boolean func_149744_f(BlockState state) {
        return this.field_150181_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int func_176337_b(int p_176337_0_) {
        float f = (float)p_176337_0_ / 15.0f;
        float f1 = f * 0.6f + 0.4f;
        if (p_176337_0_ == 0) {
            f1 = 0.3f;
        }
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        int i = MathHelper.func_76125_a((int)((int)(f1 * 255.0f)), (int)0, (int)255);
        int j = MathHelper.func_76125_a((int)((int)(f2 * 255.0f)), (int)0, (int)255);
        int k = MathHelper.func_76125_a((int)((int)(f3 * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((IProperty)field_176351_O);
        if (i != 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d1 = (float)pos.func_177956_o() + 0.0625f;
            double d2 = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            float f = (float)i / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
            float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_176348_a, state.func_177229_b((IProperty)field_176349_M)))).func_206870_a((IProperty)field_176347_b, state.func_177229_b((IProperty)field_176350_N)))).func_206870_a((IProperty)field_176349_M, state.func_177229_b((IProperty)field_176348_a)))).func_206870_a((IProperty)field_176350_N, state.func_177229_b((IProperty)field_176347_b)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_176348_a, state.func_177229_b((IProperty)field_176347_b)))).func_206870_a((IProperty)field_176347_b, state.func_177229_b((IProperty)field_176349_M)))).func_206870_a((IProperty)field_176349_M, state.func_177229_b((IProperty)field_176350_N)))).func_206870_a((IProperty)field_176350_N, state.func_177229_b((IProperty)field_176348_a)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_176348_a, state.func_177229_b((IProperty)field_176350_N)))).func_206870_a((IProperty)field_176347_b, state.func_177229_b((IProperty)field_176348_a)))).func_206870_a((IProperty)field_176349_M, state.func_177229_b((IProperty)field_176347_b)))).func_206870_a((IProperty)field_176350_N, state.func_177229_b((IProperty)field_176349_M)));
            }
        }
        return state;
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_176348_a, state.func_177229_b((IProperty)field_176349_M)))).func_206870_a((IProperty)field_176349_M, state.func_177229_b((IProperty)field_176348_a)));
            }
            case FRONT_BACK: {
                return (BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_176347_b, state.func_177229_b((IProperty)field_176350_N)))).func_206870_a((IProperty)field_176350_N, state.func_177229_b((IProperty)field_176347_b)));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176348_a, field_176347_b, field_176349_M, field_176350_N, field_176351_O});
    }
}

