/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Stat;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public interface IBlockGui {
    default public void writeExtraGuiData(PacketBuffer packetBuffer, World world, PlayerEntity player, BlockPos blockPos, Hand hand, BlockRayTraceResult rayTraceResult) {
    }

    @Nullable
    default public Stat<ResourceLocation> getOpenStat() {
        return null;
    }

    public static ActionResultType onBlockActivatedHook(IBlockGui block, IBlockContainerProvider blockContainerProvider, BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        INamedContainerProvider containerProvider;
        if (player.func_213453_ef()) {
            return ActionResultType.PASS;
        }
        if (!world.func_201670_d() && (containerProvider = blockContainerProvider.get(blockState, world, blockPos)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProvider, packetBuffer -> block.writeExtraGuiData((PacketBuffer)packetBuffer, world, player, blockPos, hand, rayTraceResult));
            Stat<ResourceLocation> openStat = block.getOpenStat();
            if (openStat != null) {
                player.func_71029_a(openStat);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public static interface IBlockContainerProvider {
        @Nullable
        public INamedContainerProvider get(BlockState var1, World var2, BlockPos var3);
    }
}

