/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.item.builder.BuildStyle;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.BuilderItem;
import com.lothrazar.cyclic.item.builder.PacketSwapBlock;
import com.lothrazar.cyclic.item.random.RandomizerItem;
import com.lothrazar.cyclic.render.FakeBlockRenderTypes;
import com.lothrazar.cyclic.util.UtilRender;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventRender {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderOverlay(RenderWorldLastEvent evt) {
        PlayerEntity player = ModCyclic.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = BuilderItem.getIfHeld(player);
        if (stack.func_77973_b() instanceof BuilderItem) {
            this.builderItemRender(evt, player, stack);
        }
        if ((stack = RandomizerItem.getIfHeld(player)).func_77973_b() instanceof RandomizerItem) {
            this.randomizerItemRender(evt, player, stack);
        }
    }

    private void randomizerItemRender(RenderWorldLastEvent evt, PlayerEntity player, ItemStack stack) {
        World world = player.field_70170_p;
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        int range = 5;
        BlockRayTraceResult lookingAt = (BlockRayTraceResult)player.func_213324_a((double)range, 0.0f, false);
        if (world.func_180495_p(lookingAt.func_216350_a()) == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        List<BlockPos> coords = RandomizerItem.getPlaces(lookingAt.func_216350_a(), lookingAt.func_216354_b());
        Vec3d view = mc.field_71460_t.func_215316_n().func_216785_c();
        MatrixStack matrix = evt.getMatrixStack();
        matrix.func_227860_a_();
        matrix.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        IVertexBuilder builder = buffer.getBuffer(FakeBlockRenderTypes.TRANSPARENT_COLOUR);
        for (BlockPos e : coords) {
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)e.func_177958_n(), (double)e.func_177956_o(), (double)e.func_177952_p());
            matrix.func_227861_a_((double)-0.005f, (double)-0.005f, (double)-0.005f);
            matrix.func_227862_a_(1.01f, 1.01f, 1.01f);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
            Color color = RandomizerItem.canMove(world.func_180495_p(e), world, e) ? Color.GREEN : Color.RED;
            UtilRender.renderCube(positionMatrix, builder, e, color);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
        RenderSystem.disableDepthTest();
        buffer.func_228462_a_(FakeBlockRenderTypes.TRANSPARENT_COLOUR);
    }

    private void builderItemRender(RenderWorldLastEvent evt, PlayerEntity player, ItemStack stack) {
        World world = player.field_70170_p;
        BuildStyle buildStyle = ((BuilderItem)stack.func_77973_b()).style;
        BlockState renderBlockState = BuilderActionType.getBlockState(stack);
        if (renderBlockState == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        double range = 6.0;
        BlockRayTraceResult lookingAt = (BlockRayTraceResult)player.func_213324_a(range, 0.0f, false);
        if (world.func_175623_d(lookingAt.func_216350_a())) {
            return;
        }
        BlockPos pos = lookingAt.func_216350_a();
        if (buildStyle.isOffset() && lookingAt.func_216354_b() != null) {
            pos = pos.func_177972_a(lookingAt.func_216354_b());
        }
        MatrixStack matrix = evt.getMatrixStack();
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(FakeBlockRenderTypes.FAKE_BLOCK);
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        matrix.func_227860_a_();
        Vec3d playerPos = mc.field_71460_t.func_215316_n().func_216785_c();
        matrix.func_227861_a_(-playerPos.func_82615_a(), -playerPos.func_82617_b(), -playerPos.func_82616_c());
        List<BlockPos> coordinates = PacketSwapBlock.getSelectedBlocks(world, pos, BuilderItem.getActionType(stack), lookingAt.func_216354_b(), buildStyle);
        for (BlockPos coordinate : coordinates) {
            float x = coordinate.func_177958_n();
            float y = coordinate.func_177956_o();
            float z = coordinate.func_177952_p();
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)x, (double)y, (double)z);
            matrix.func_227861_a_((double)-5.0E-4f, (double)-5.0E-4f, (double)-5.0E-4f);
            matrix.func_227862_a_(1.001f, 1.001f, 1.001f);
            IBakedModel ibakedmodel = dispatcher.func_184389_a(renderBlockState);
            BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
            int color = blockColors.func_228054_a_(renderBlockState, (ILightReader)player.field_70170_p, coordinate, 0);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            float alpha = 0.7f;
            try {
                if (renderBlockState.func_185901_i() == BlockRenderType.MODEL) {
                    for (Direction direction : Direction.values()) {
                        UtilRender.renderModelBrightnessColorQuads(matrix.func_227866_c_(), builder, red, green, blue, alpha, ibakedmodel.getQuads(renderBlockState, direction, new Random(MathHelper.func_180186_a((Vec3i)coordinate)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 327680);
                    }
                    UtilRender.renderModelBrightnessColorQuads(matrix.func_227866_c_(), builder, red, green, blue, alpha, ibakedmodel.getQuads(renderBlockState, null, new Random(MathHelper.func_180186_a((Vec3i)coordinate)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
                }
            }
            catch (Throwable t) {
                ModCyclic.LOGGER.trace("Block at {} with state {} threw exception, whilst rendering", (Object)coordinate, (Object)renderBlockState, (Object)t);
            }
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }
}

