/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.entity.EntitySignalFlare;

public class ItemBottledMana
extends Item {
    private static final int SWIGS = 6;
    private static final String TAG_SWIGS_LEFT = "swigsLeft";
    private static final String TAG_SEED = "randomSeed";

    public ItemBottledMana(Item.Properties props) {
        super(props);
        this.func_185043_a(new ResourceLocation("botania", "swigs_taken"), (stack, world, entity) -> 6 - this.getSwigsLeft(stack));
    }

    public void effect(ItemStack stack, LivingEntity living, int id) {
        block0 : switch (id) {
            case 0: {
                living.func_213293_j((Math.random() - 0.5) * 3.0, living.func_213322_ci().func_82617_b(), (Math.random() - 0.5) * 3.0);
                break;
            }
            case 1: {
                if (living.field_70170_p.field_72995_K || living.field_70170_p.func_201675_m().func_177500_n()) break;
                living.field_70170_p.func_175656_a(new BlockPos((Entity)living), Blocks.field_150355_j.func_176223_P());
                break;
            }
            case 2: {
                if (living.field_70170_p.field_72995_K) break;
                living.func_70015_d(4);
                break;
            }
            case 3: {
                if (living.field_70170_p.field_72995_K) break;
                living.field_70170_p.func_217385_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), 0.25f, Explosion.Mode.NONE);
                break;
            }
            case 4: {
                if (living.field_70170_p.func_201675_m().func_177495_o()) break;
                if (!living.field_70170_p.field_72995_K) {
                    living.func_195064_c(new EffectInstance(Effects.field_76429_m, 300, 5));
                }
                living.func_213293_j(living.func_213322_ci().func_82615_a(), 6.0, living.func_213322_ci().func_82616_c());
                break;
            }
            case 5: {
                if (living.field_70170_p.field_72995_K) break;
                living.func_70606_j((float)(living.field_70170_p.field_73012_v.nextInt(19) + 1));
                break;
            }
            case 6: {
                if (living.field_70170_p.field_72995_K) break;
                living.func_195064_c(new EffectInstance(Effects.field_76444_x, 2400, 9));
                break;
            }
            case 7: {
                if (living.field_70170_p.field_72995_K || !(living instanceof PlayerEntity)) break;
                PlayerEntity player = (PlayerEntity)living;
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stackAt = player.field_71071_by.func_70301_a(i);
                    if (stackAt == stack) continue;
                    if (!stackAt.func_190926_b()) {
                        player.func_70099_a(stackAt, 0.0f);
                    }
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
                break;
            }
            case 8: {
                living.field_70125_A = (float)Math.random() * 360.0f;
                living.field_70177_z = (float)Math.random() * 180.0f;
                break;
            }
            case 9: {
                int x = MathHelper.func_76128_c((double)living.func_226277_ct_());
                int z = MathHelper.func_76128_c((double)living.func_226281_cx_());
                for (int i = 256; i > 0; --i) {
                    Block block = living.field_70170_p.func_180495_p(new BlockPos(x, i, z)).func_177230_c();
                    if (block.isAir(living.field_70170_p.func_180495_p(new BlockPos(x, i, z)), (IBlockReader)living.field_70170_p, new BlockPos(x, i, z))) continue;
                    if (!(living instanceof ServerPlayerEntity)) break block0;
                    ServerPlayerEntity mp = (ServerPlayerEntity)living;
                    mp.field_71135_a.func_147364_a(living.func_226277_ct_(), (double)i, living.func_226281_cx_(), living.field_70177_z, living.field_70125_A);
                    break block0;
                }
                break;
            }
            case 10: {
                if (living.field_70170_p.field_72995_K) break;
                living.func_195064_c(new EffectInstance(Effects.field_76424_c, 60, 200));
                break;
            }
            case 11: {
                if (living.field_70170_p.field_72995_K) break;
                living.func_195064_c(new EffectInstance(Effects.field_76439_r, 6000, 0));
                break;
            }
            case 12: {
                if (living.field_70170_p.field_72995_K) break;
                EntitySignalFlare flare = new EntitySignalFlare(living.field_70170_p);
                flare.func_70107_b(living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_());
                flare.setColor(living.field_70170_p.field_73012_v.nextInt(16));
                flare.func_184185_a(SoundEvents.field_187539_bB, 40.0f, (1.0f + (living.field_70170_p.field_73012_v.nextFloat() - living.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                living.field_70170_p.func_217376_c((Entity)flare);
                int range = 5;
                List entities = living.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(living.func_226277_ct_() - (double)range, living.func_226278_cu_() - (double)range, living.func_226281_cx_() - (double)range, living.func_226277_ct_() + (double)range, living.func_226278_cu_() + (double)range, living.func_226281_cx_() + (double)range));
                for (LivingEntity entity : entities) {
                    if (entity == living || entity instanceof PlayerEntity && ServerLifecycleHooks.getCurrentServer() != null && !ServerLifecycleHooks.getCurrentServer().func_71219_W()) continue;
                    entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 50, 5));
                }
                break;
            }
            case 13: {
                if (living.field_70170_p.field_72995_K) break;
                EntityPixie pixie = new EntityPixie(living.field_70170_p);
                pixie.func_70107_b(living.func_226277_ct_(), living.func_226278_cu_() + 1.5, living.func_226281_cx_());
                living.field_70170_p.func_217376_c((Entity)pixie);
                break;
            }
            case 14: {
                if (living.field_70170_p.field_72995_K) break;
                living.func_195064_c(new EffectInstance(Effects.field_76431_k, 160, 3));
                living.func_195064_c(new EffectInstance(Effects.field_76440_q, 160, 0));
                break;
            }
            case 15: {
                if (living.field_70170_p.field_72995_K || !(living instanceof PlayerEntity)) break;
                living.func_70097_a(DamageSource.field_76376_m, living.func_110143_aJ() - 1.0f);
                ItemStack skull = new ItemStack((IItemProvider)Items.field_196184_dx);
                ItemNBTHelper.setString(skull, "SkullOwner", ((PlayerEntity)living).func_146103_bH().getName());
                living.func_70099_a(skull, 0.0f);
            }
        }
    }

    private void randomEffect(LivingEntity player, ItemStack stack) {
        this.effect(stack, player, new Random(this.getSeed(stack)).nextInt(16));
    }

    private long getSeed(ItemStack stack) {
        long seed = ItemNBTHelper.getLong(stack, TAG_SEED, -1L);
        if (seed == -1L) {
            return this.randomSeed(stack);
        }
        return seed;
    }

    private long randomSeed(ItemStack stack) {
        long seed = Math.abs(field_77697_d.nextLong());
        ItemNBTHelper.setLong(stack, TAG_SEED, seed);
        return seed;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> stacks, ITooltipFlag flags) {
        stacks.add((ITextComponent)new TranslationTextComponent("botaniamisc.bottleTooltip", new Object[0]));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, LivingEntity living) {
        this.randomEffect(living, stack);
        int left = this.getSwigsLeft(stack);
        if (left <= 1) {
            return new ItemStack((IItemProvider)Items.field_151069_bo);
        }
        this.setSwigsLeft(stack, left - 1);
        this.randomSeed(stack);
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    private int getSwigsLeft(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, 6);
    }

    private void setSwigsLeft(ItemStack stack, int swigs) {
        ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
    }
}

