/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.entity.EntityThrowableCopy;

public class EntityFallingStar
extends EntityThrowableCopy {
    @ObjectHolder(value="botania:falling_star")
    public static EntityType<EntityFallingStar> TYPE;

    public EntityFallingStar(EntityType<EntityFallingStar> type, World world) {
        super(type, world);
    }

    public EntityFallingStar(LivingEntity e, World world) {
        super(TYPE, e, world);
    }

    protected void func_70088_a() {
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        float dist = 1.5f;
        SparkleParticleData data = SparkleParticleData.sparkle(2.0f, 1.0f, 0.4f, 1.0f, 6);
        for (int i = 0; i < 10; ++i) {
            float xs = (float)(Math.random() - 0.5) * dist;
            float ys = (float)(Math.random() - 0.5) * dist;
            float zs = (float)(Math.random() - 0.5) * dist;
            this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + (double)xs, this.func_226278_cu_() + (double)ys, this.func_226281_cx_() + (double)zs, 0.0, 0.0, 0.0);
        }
        LivingEntity thrower = this.getThrower();
        if (!this.field_70170_p.field_72995_K && thrower != null) {
            AxisAlignedBB axis = new AxisAlignedBB(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70142_S, this.field_70137_T, this.field_70136_U).func_186662_g(2.0);
            List entities = this.field_70170_p.func_217357_a(LivingEntity.class, axis);
            for (LivingEntity living : entities) {
                if (living == thrower || living.field_70737_aN != 0) continue;
                this.onImpact((RayTraceResult)new EntityRayTraceResult((Entity)living));
                return;
            }
        }
        if (this.field_70173_aa > 200) {
            this.func_70106_y();
        }
    }

    @Override
    protected void onImpact(RayTraceResult pos) {
        Entity e;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        LivingEntity thrower = this.getThrower();
        if (pos.func_216346_c() == RayTraceResult.Type.ENTITY && thrower != null && (e = ((EntityRayTraceResult)pos).func_216348_a()) != thrower && e.func_70089_S()) {
            if (thrower instanceof PlayerEntity) {
                e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)thrower)), Math.random() < 0.25 ? 10.0f : 5.0f);
            } else {
                e.func_70097_a(DamageSource.field_76377_j, Math.random() < 0.25 ? 10.0f : 5.0f);
            }
        }
        if (pos.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos bpos = ((BlockRayTraceResult)pos).func_216350_a();
            BlockState state = this.field_70170_p.func_180495_p(bpos);
            if (((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue() && !state.isAir((IBlockReader)this.field_70170_p, bpos)) {
                this.field_70170_p.func_217379_c(2001, bpos, Block.func_196246_j((BlockState)state));
            }
        }
        this.func_70106_y();
    }
}

