/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LokiPlaceTrigger
implements ICriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("botania", "loki_placed_blocks");
    public static final LokiPlaceTrigger INSTANCE = new LokiPlaceTrigger();
    private final Map<PlayerAdvancements, PlayerTracker> playerTrackers = new HashMap<PlayerAdvancements, PlayerTracker>();

    private LokiPlaceTrigger() {
    }

    @Nonnull
    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements player, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        this.playerTrackers.computeIfAbsent((PlayerAdvancements)player, (Function<PlayerAdvancements, PlayerTracker>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.advancements.PlayerAdvancements ), (Lnet/minecraft/advancements/PlayerAdvancements;)Lvazkii/botania/common/advancements/LokiPlaceTrigger$PlayerTracker;)()).listeners.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements player, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        PlayerTracker tracker = this.playerTrackers.get(player);
        if (tracker != null) {
            tracker.listeners.remove(listener);
            if (tracker.listeners.isEmpty()) {
                this.playerTrackers.remove(player);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements player) {
        this.playerTrackers.remove(player);
    }

    @Nonnull
    public Instance deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        return new Instance(EntityPredicate.func_192481_a((JsonElement)json.get("player")), ItemPredicate.func_192492_a((JsonElement)json.get("ring")), MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("blocks_placed")));
    }

    public void trigger(ServerPlayerEntity player, ItemStack ring, int blocksPlaced) {
        PlayerTracker tracker = this.playerTrackers.get(player.func_192039_O());
        if (tracker != null) {
            tracker.trigger(player, ring, blocksPlaced);
        }
    }

    static class Instance
    implements ICriterionInstance {
        private final EntityPredicate player;
        private final ItemPredicate ring;
        private final MinMaxBounds.IntBound blocksPlaced;

        Instance(EntityPredicate player, ItemPredicate ring, MinMaxBounds.IntBound blocksPlaced) {
            this.player = player;
            this.ring = ring;
            this.blocksPlaced = blocksPlaced;
        }

        @Nonnull
        public ResourceLocation func_192244_a() {
            return ID;
        }

        boolean test(ServerPlayerEntity player, ItemStack ring, int blocksPlaced) {
            return this.player.func_192482_a(player, null) && this.ring.func_192493_a(ring) && this.blocksPlaced.func_211339_d(blocksPlaced);
        }
    }

    static class PlayerTracker {
        private final PlayerAdvancements playerAdvancements;
        final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        PlayerTracker(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public void trigger(ServerPlayerEntity player, ItemStack ring, int blocksPlaced) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(player, ring, blocksPlaced)) continue;
                list.add(listener);
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }
}

