/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class CorporeaRequestTrigger
implements ICriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("botania", "corporea_index_request");
    public static final CorporeaRequestTrigger INSTANCE = new CorporeaRequestTrigger();
    private final Map<PlayerAdvancements, PlayerTracker> playerTrackers = new HashMap<PlayerAdvancements, PlayerTracker>();

    private CorporeaRequestTrigger() {
    }

    @Nonnull
    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements player, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        this.playerTrackers.computeIfAbsent((PlayerAdvancements)player, (Function<PlayerAdvancements, PlayerTracker>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.advancements.PlayerAdvancements ), (Lnet/minecraft/advancements/PlayerAdvancements;)Lvazkii/botania/common/advancements/CorporeaRequestTrigger$PlayerTracker;)()).listeners.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements player, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        PlayerTracker tracker = this.playerTrackers.get(player);
        if (tracker != null) {
            tracker.listeners.remove(listener);
            if (tracker.listeners.isEmpty()) {
                this.playerTrackers.remove(player);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements player) {
        this.playerTrackers.remove(player);
    }

    @Nonnull
    public Instance deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        return new Instance(MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("extracted")), LocationPredicate.func_193454_a((JsonElement)json.get("location")));
    }

    public void trigger(ServerPlayerEntity player, ServerWorld world, BlockPos pos, int count) {
        PlayerTracker tracker = this.playerTrackers.get(player.func_192039_O());
        if (tracker != null) {
            tracker.trigger(world, pos, count);
        }
    }

    static class Instance
    implements ICriterionInstance {
        private final MinMaxBounds.IntBound count;
        private final LocationPredicate indexPos;

        Instance(MinMaxBounds.IntBound count, LocationPredicate indexPos) {
            this.count = count;
            this.indexPos = indexPos;
        }

        @Nonnull
        public ResourceLocation func_192244_a() {
            return ID;
        }

        boolean test(ServerWorld world, BlockPos pos, int count) {
            return this.count.func_211339_d(count) && this.indexPos.func_193453_a(world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        }
    }

    static class PlayerTracker {
        private final PlayerAdvancements playerAdvancements;
        final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        PlayerTracker(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public void trigger(ServerWorld world, BlockPos pos, int count) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(world, pos, count)) continue;
                list.add(listener);
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }
}

