/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet;

import com.yogpc.qp.QuarryPlus;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkEvent;

public interface IMessage<T extends IMessage<T>> {
    public static int getDimId(@Nullable World world) {
        return Optional.ofNullable(world).map(World::func_201675_m).map(Dimension::func_186058_p).map(DimensionType::func_186068_a).orElse(0);
    }

    public static <T extends IMessage<T>> Function<PacketBuffer, T> decode(Supplier<T> supplier) {
        return buffer -> ((IMessage)supplier.get()).readFromBuffer((PacketBuffer)buffer);
    }

    public T readFromBuffer(PacketBuffer var1);

    public void writeToBuffer(PacketBuffer var1);

    public void onReceive(Supplier<NetworkEvent.Context> var1);

    default public void onReceiveInternal(Supplier<NetworkEvent.Context> ctx) {
        this.onReceive(ctx);
        ctx.get().setPacketHandled(true);
    }

    public static <T extends TileEntity> Optional<T> findTile(Supplier<NetworkEvent.Context> ctx, BlockPos pos, int dim, Class<T> aClass) {
        return QuarryPlus.proxy.getPacketWorld(ctx.get()).filter(world -> world.func_201675_m().func_186058_p().func_186068_a() == dim).filter(world -> world.func_195588_v(pos)).map(world -> world.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(aClass));
    }
}

