/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets.renderers;

import com.direwolf20.buildinggadgets.client.cache.RemoteInventoryCache;
import com.direwolf20.buildinggadgets.client.renderer.FakeTERWorld;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.tools.UniqueItem;
import com.direwolf20.buildinggadgets.common.world.MockBuilderWorld;
import com.google.common.collect.Multiset;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.lwjgl.opengl.GL14;

public abstract class BaseRenderer {
    public static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final FakeTERWorld tileEntityWorld = new FakeTERWorld();
    private static final MockBuilderWorld builderWorld = new MockBuilderWorld();
    private static final Set<TileEntity> invalidTileEntities = new HashSet<TileEntity>();
    private static RemoteInventoryCache cacheInventory = new RemoteInventoryCache(false);

    public void render(RenderWorldLastEvent evt, PlayerEntity player, ItemStack heldItem) {
        this.bindBlocks();
    }

    private void bindBlocks() {
        BaseRenderer.getMc().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
    }

    private static void renderLinkedInventoryOutline(RenderWorldLastEvent evt, ItemStack item, PlayerEntity player) {
        ResourceLocation dim = GadgetUtils.getDIMFromNBT(item, "bound_te_pos");
        BlockPos pos = GadgetUtils.getPOSFromNBT(item, "bound_te_pos");
        if (dim == null || pos == null) {
            return;
        }
        DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)dim);
        if (dimension == null || player.field_71093_bK != dimension) {
            return;
        }
        Vec3d renderPos = BaseRenderer.getMc().field_71460_t.func_215316_n().func_216785_c().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72441_c((double)0.005f, (double)0.005f, (double)-0.005f);
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)32771, (int)32772);
        RenderSystem.translated((double)(-renderPos.func_82615_a()), (double)(-renderPos.func_82617_b()), (double)(-renderPos.func_82616_c()));
        RenderSystem.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.scalef((float)1.01f, (float)1.01f, (float)1.01f);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        BaseRenderer.getMc().func_175602_ab().func_228791_a_(Blocks.field_196811_gn.func_176223_P(), evt.getMatrixStack(), (IRenderTypeBuffer)IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c()), 0, 0);
        RenderSystem.popMatrix();
    }

    int getEnergy(PlayerEntity player, ItemStack heldItem) {
        LazyOptional energy = heldItem.getCapability(CapabilityEnergy.ENERGY);
        if (player.func_184812_l_() || !energy.isPresent()) {
            return Integer.MAX_VALUE;
        }
        return (Integer)energy.map(IEnergyStorage::getEnergyStored).orElse((Object)0);
    }

    protected void renderMissingBlock(Matrix4f matrix, IVertexBuilder builder, BlockPos pos) {
        float red = 1.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float alpha = 0.35f;
        double x = (double)pos.func_177958_n() - 0.001;
        double y = (double)pos.func_177956_o() - 0.001;
        double z = (double)pos.func_177952_p() - 0.001;
        double xEnd = (double)pos.func_177958_n() + 1.0015;
        double yEnd = (double)pos.func_177956_o() + 1.0015;
        double zEnd = (double)pos.func_177952_p() + 1.0015;
        this.renderBoxSolid(matrix, builder, x, y, z, xEnd, yEnd, zEnd, red, green, blue, alpha);
    }

    protected void renderBoxSolid(Matrix4f matrix, IVertexBuilder builder, double x, double y, double z, double xEnd, double yEnd, double zEnd, float red, float green, float blue, float alpha) {
        float xf = (float)x;
        float yf = (float)y;
        float zf = (float)z;
        float xEndf = (float)xEnd;
        float yEndf = (float)yEnd;
        float zEndf = (float)zEnd;
        builder.func_227888_a_(matrix, xf, yf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yEndf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yEndf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yEndf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yEndf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yEndf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yEndf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yEndf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yEndf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yEndf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yEndf, zf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yEndf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yEndf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xf, yf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, xEndf, yf, zEndf).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public boolean isLinkable() {
        return false;
    }

    static Minecraft getMc() {
        return Minecraft.func_71410_x();
    }

    static FakeTERWorld getTileEntityWorld() {
        return tileEntityWorld;
    }

    static MockBuilderWorld getBuilderWorld() {
        return builderWorld;
    }

    static RemoteInventoryCache getCacheInventory() {
        return cacheInventory;
    }

    public static void setInventoryCache(Multiset<UniqueItem> cache) {
        cacheInventory.setCache(cache);
    }

    public static void updateInventoryCache() {
        cacheInventory.forceUpdate();
    }

    static Set<TileEntity> getInvalidTileEntities() {
        return invalidTileEntities;
    }
}

