/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.load.registration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.collect.ListMultiMap;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;

public class GuiHandlerRegistration
implements IGuiHandlerRegistration {
    private final ListMultiMap<Class<? extends ContainerScreen>, IGuiContainerHandler<?>> guiHandlers = new ListMultiMap();
    private final List<IGlobalGuiHandler> globalGuiHandlers = new ArrayList<IGlobalGuiHandler>();
    private final Map<Class, IScreenHandler> guiScreenHandlers = new HashMap<Class, IScreenHandler>();
    private final Map<Class, IGhostIngredientHandler> ghostIngredientHandlers = new HashMap<Class, IGhostIngredientHandler>();
    private static final List<Class<? extends Screen>> ghostIngredientGuiBlacklist = ImmutableList.of(Screen.class, InventoryScreen.class, CreativeScreen.class);

    @Override
    public <T extends ContainerScreen<?>> void addGuiContainerHandler(Class<? extends T> guiClass, IGuiContainerHandler<T> guiHandler) {
        ErrorUtil.checkNotNull(guiClass, "guiClass");
        ErrorUtil.checkNotNull(guiHandler, "guiHandler");
        this.guiHandlers.put(guiClass, guiHandler);
    }

    @Override
    public void addGlobalGuiHandler(IGlobalGuiHandler globalGuiHandler) {
        ErrorUtil.checkNotNull(globalGuiHandler, "globalGuiHandler");
        this.globalGuiHandlers.add(globalGuiHandler);
    }

    @Override
    public <T extends Screen> void addGuiScreenHandler(Class<T> guiClass, IScreenHandler<T> handler) {
        ErrorUtil.checkNotNull(guiClass, "guiClass");
        Preconditions.checkArgument((boolean)Screen.class.isAssignableFrom(guiClass), (Object)"guiClass must inherit from Screen");
        Preconditions.checkArgument((!Screen.class.equals(guiClass) ? 1 : 0) != 0, (Object)"you cannot add a handler for Screen, only a subclass.");
        ErrorUtil.checkNotNull(handler, "guiScreenHandler");
        this.guiScreenHandlers.put(guiClass, handler);
    }

    @Override
    public <T extends Screen> void addGhostIngredientHandler(Class<T> guiClass, IGhostIngredientHandler<T> handler) {
        ErrorUtil.checkNotNull(guiClass, "guiClass");
        Preconditions.checkArgument((boolean)Screen.class.isAssignableFrom(guiClass), (Object)"guiClass must inherit from Screen");
        Preconditions.checkArgument((!ghostIngredientGuiBlacklist.contains(guiClass) ? 1 : 0) != 0, (String)"you cannot add a ghost ingredient handler for the following Guis, it would interfere with using JEI: %s", ghostIngredientGuiBlacklist);
        ErrorUtil.checkNotNull(handler, "handler");
        this.ghostIngredientHandlers.put(guiClass, handler);
    }

    public ListMultiMap<Class<? extends ContainerScreen>, IGuiContainerHandler<?>> getGuiHandlers() {
        return this.guiHandlers;
    }

    public List<IGlobalGuiHandler> getGlobalGuiHandlers() {
        return this.globalGuiHandlers;
    }

    public Map<Class, IScreenHandler> getGuiScreenHandlers() {
        return this.guiScreenHandlers;
    }

    public Map<Class, IGhostIngredientHandler> getGhostIngredientHandlers() {
        return this.ghostIngredientHandlers;
    }
}

