/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.loot.function;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.parts.LazyPartData;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;

public final class SetPartsFunction
extends LootFunction {
    public static final Serializer SERIALIZER = new Serializer();
    private final List<LazyPartData> parts;

    private SetPartsFunction(ILootCondition[] conditions, List<LazyPartData> parts) {
        super(conditions);
        this.parts = parts;
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        if (!(stack.func_77973_b() instanceof ICoreItem)) {
            return stack;
        }
        ItemStack result = stack.func_77946_l();
        List<PartData> parts = LazyPartData.createPartList(this.parts);
        parts.forEach(p -> p.onAddToGear(result));
        GearData.writeConstructionParts(result, parts);
        GearData.recalculateStats(result, null);
        return result;
    }

    public static LootFunction.Builder<?> builder(List<LazyPartData> parts) {
        return SetPartsFunction.func_215860_a(conditions -> new SetPartsFunction((ILootCondition[])conditions, parts));
    }

    public static class Serializer
    extends LootFunction.Serializer<SetPartsFunction> {
        public Serializer() {
            super(SilentGear.getId("set_parts"), SetPartsFunction.class);
        }

        public SetPartsFunction deserialize(JsonObject json, JsonDeserializationContext context, ILootCondition[] conditionsIn) {
            ArrayList<LazyPartData> parts = new ArrayList<LazyPartData>();
            JsonArray partsArray = JSONUtils.func_151213_a((JsonObject)json, (String)"parts", (JsonArray)new JsonArray());
            for (JsonElement jsonElement : partsArray) {
                parts.add(LazyPartData.readJson(jsonElement));
            }
            return new SetPartsFunction(conditionsIn, parts);
        }
    }
}

