/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ToolType;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.gear.CoreAxe;
import net.silentchaos512.gear.item.gear.CoreSickle;
import net.silentchaos512.gear.item.gear.CoreSword;
import net.silentchaos512.gear.util.GearHelper;

public class CoreMachete
extends CoreSword {
    private static final int BREAK_RANGE = 2;
    private static final Set<Material> EFFECTIVE_MATERIALS = Sets.union(CoreSickle.EFFECTIVE_MATERIALS, (Set)ImmutableSet.of((Object)Material.field_215713_z));

    public CoreMachete() {
        super(ToolType.AXE);
    }

    @Override
    public GearType getGearType() {
        return GearType.MACHETE;
    }

    @Override
    public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        if (stat == ItemStats.MELEE_DAMAGE) {
            return Optional.of(StatInstance.makeBaseMod(4.0f));
        }
        if (stat == ItemStats.ATTACK_SPEED) {
            return Optional.of(StatInstance.makeBaseMod(-2.6f));
        }
        if (stat == ItemStats.REPAIR_EFFICIENCY) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        return Optional.empty();
    }

    @Override
    public Optional<StatInstance> getStatModifier(ItemStat stat) {
        if (stat == ItemStats.DURABILITY) {
            return Optional.of(StatInstance.makeGearMod(0.2f));
        }
        if (stat == ItemStats.ENCHANTABILITY) {
            return Optional.of(StatInstance.makeGearMod(-0.1f));
        }
        return Optional.empty();
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        if (!player.func_213453_ef()) {
            return ModItems.sickle.onSickleStartBreak(itemstack, pos, player, 2, EFFECTIVE_MATERIALS);
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return GearHelper.getHarvestLevel(stack, tool, blockState, null);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        float speed = GearHelper.getDestroySpeed(stack, state, CoreAxe.EXTRA_EFFECTIVE_MATERIALS);
        if (CoreAxe.BASE_EFFECTIVE_MATERIALS.contains(state.func_185904_a())) {
            return speed * 0.4f;
        }
        return speed;
    }
}

