/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTable {
    private static final Logger field_186465_b = LogManager.getLogger();
    public static final LootTable field_186464_a = new LootTable(LootParameterSets.field_216260_a, new LootPool[0], new ILootFunction[0]);
    public static final LootParameterSet field_216126_b = LootParameterSets.field_216266_g;
    private final LootParameterSet field_216127_d;
    private final LootPool[] field_186466_c;
    private final ILootFunction[] field_216128_f;
    private final BiFunction<ItemStack, LootContext, ItemStack> field_216129_g;

    private LootTable(LootParameterSet lootParameterSet, LootPool[] lootPoolArray, ILootFunction[] iLootFunctionArray) {
        this.field_216127_d = lootParameterSet;
        this.field_186466_c = lootPoolArray;
        this.field_216128_f = iLootFunctionArray;
        this.field_216129_g = LootFunctionManager.func_216241_a(iLootFunctionArray);
    }

    public static Consumer<ItemStack> func_216124_a(Consumer<ItemStack> consumer) {
        return itemStack -> {
            if (itemStack.func_190916_E() < itemStack.func_77976_d()) {
                consumer.accept((ItemStack)itemStack);
            } else {
                for (int i = itemStack.func_190916_E(); i > 0; i -= itemStack2.func_190916_E()) {
                    ItemStack itemStack2 = itemStack.func_77946_l();
                    itemStack2.func_190920_e(Math.min(itemStack.func_77976_d(), i));
                    consumer.accept(itemStack2);
                }
            }
        };
    }

    public void func_216114_a(LootContext lootContext2, Consumer<ItemStack> consumer) {
        if (lootContext2.func_186496_a(this)) {
            LootContext lootContext2;
            \u2603 = ILootFunction.func_215858_a(this.field_216129_g, consumer, lootContext2);
            for (LootPool lootPool : this.field_186466_c) {
                lootPool.func_216091_a(\u2603, lootContext2);
            }
            lootContext2.func_186490_b(this);
        } else {
            field_186465_b.warn("Detected infinite loop in loot tables");
        }
    }

    public void func_216120_b(LootContext lootContext, Consumer<ItemStack> consumer) {
        this.func_216114_a(lootContext, LootTable.func_216124_a(consumer));
    }

    public List<ItemStack> func_216113_a(LootContext lootContext) {
        ArrayList arrayList = Lists.newArrayList();
        this.func_216120_b(lootContext, arrayList::add);
        return arrayList;
    }

    public LootParameterSet func_216122_a() {
        return this.field_216127_d;
    }

    public void func_227506_a_(ValidationTracker validationTracker) {
        int n;
        for (n = 0; n < this.field_186466_c.length; ++n) {
            this.field_186466_c[n].func_227505_a_(validationTracker.func_227534_b_(".pools[" + n + "]"));
        }
        for (n = 0; n < this.field_216128_f.length; ++n) {
            this.field_216128_f[n].func_225580_a_(validationTracker.func_227534_b_(".functions[" + n + "]"));
        }
    }

    public void func_216118_a(IInventory iInventory, LootContext lootContext) {
        List<ItemStack> list = this.func_216113_a(lootContext);
        Random \u26032 = lootContext.func_216032_b();
        List<Integer> \u26033 = this.func_186459_a(iInventory, \u26032);
        this.func_186463_a(list, \u26033.size(), \u26032);
        for (ItemStack itemStack : list) {
            if (\u26033.isEmpty()) {
                field_186465_b.warn("Tried to over-fill a container");
                return;
            }
            if (itemStack.func_190926_b()) {
                iInventory.func_70299_a(\u26033.remove(\u26033.size() - 1), ItemStack.field_190927_a);
                continue;
            }
            iInventory.func_70299_a(\u26033.remove(\u26033.size() - 1), itemStack);
        }
    }

    private void func_186463_a(List<ItemStack> list2, int n2, Random random) {
        List<ItemStack> list2;
        int n2;
        ArrayList arrayList = Lists.newArrayList();
        Object \u26032 = list2.iterator();
        while (\u26032.hasNext()) {
            ItemStack itemStack = \u26032.next();
            if (itemStack.func_190926_b()) {
                \u26032.remove();
                continue;
            }
            if (itemStack.func_190916_E() <= 1) continue;
            arrayList.add(itemStack);
            \u26032.remove();
        }
        while (n2 - list2.size() - arrayList.size() > 0 && !arrayList.isEmpty()) {
            \u26032 = (ItemStack)arrayList.remove(MathHelper.func_76136_a(random, 0, arrayList.size() - 1));
            \u2603 = MathHelper.func_76136_a(random, 1, ((ItemStack)\u26032).func_190916_E() / 2);
            ItemStack itemStack = ((ItemStack)\u26032).func_77979_a(\u2603);
            if (((ItemStack)\u26032).func_190916_E() > 1 && random.nextBoolean()) {
                arrayList.add(\u26032);
            } else {
                list2.add((ItemStack)\u26032);
            }
            if (itemStack.func_190916_E() > 1 && random.nextBoolean()) {
                arrayList.add(itemStack);
                continue;
            }
            list2.add(itemStack);
        }
        list2.addAll(arrayList);
        Collections.shuffle(list2, random);
    }

    private List<Integer> func_186459_a(IInventory iInventory, Random random) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = 0; i < iInventory.func_70302_i_(); ++i) {
            if (!iInventory.func_70301_a(i).func_190926_b()) continue;
            arrayList.add(i);
        }
        Collections.shuffle(arrayList, random);
        return arrayList;
    }

    public static Builder func_216119_b() {
        return new Builder();
    }

    public static class Serializer
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            ILootFunction[] \u26034;
            JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "loot table");
            LootPool[] \u26032 = JSONUtils.func_188177_a(jsonObject, "pools", new LootPool[0], jsonDeserializationContext, LootPool[].class);
            LootParameterSet \u26033 = null;
            if (jsonObject.has("type")) {
                \u26034 = JSONUtils.func_151200_h(jsonObject, "type");
                \u26033 = LootParameterSets.func_216256_a(new ResourceLocation((String)\u26034));
            }
            \u26034 = JSONUtils.func_188177_a(jsonObject, "functions", new ILootFunction[0], jsonDeserializationContext, ILootFunction[].class);
            return new LootTable(\u26033 != null ? \u26033 : LootParameterSets.field_216266_g, \u26032, \u26034);
        }

        public JsonElement serialize(LootTable lootTable2, Type type, JsonSerializationContext jsonSerializationContext) {
            LootTable lootTable2;
            JsonObject jsonObject = new JsonObject();
            if (lootTable2.field_216127_d != field_216126_b) {
                ResourceLocation resourceLocation = LootParameterSets.func_216257_a(lootTable2.field_216127_d);
                if (resourceLocation != null) {
                    jsonObject.addProperty("type", resourceLocation.toString());
                } else {
                    field_186465_b.warn("Failed to find id for param set " + lootTable2.field_216127_d);
                }
            }
            if (lootTable2.field_186466_c.length > 0) {
                jsonObject.add("pools", jsonSerializationContext.serialize((Object)lootTable2.field_186466_c));
            }
            if (!ArrayUtils.isEmpty((Object[])lootTable2.field_216128_f)) {
                jsonObject.add("functions", jsonSerializationContext.serialize((Object)lootTable2.field_216128_f));
            }
            return jsonObject;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootTable)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }

    public static class Builder
    implements ILootFunctionConsumer<Builder> {
        private final List<LootPool> field_216041_a = Lists.newArrayList();
        private final List<ILootFunction> field_216042_b = Lists.newArrayList();
        private LootParameterSet field_216043_c = field_216126_b;

        public Builder func_216040_a(LootPool.Builder builder) {
            this.field_216041_a.add(builder.func_216044_b());
            return this;
        }

        public Builder func_216039_a(LootParameterSet lootParameterSet) {
            this.field_216043_c = lootParameterSet;
            return this;
        }

        @Override
        public Builder func_212841_b_(ILootFunction.IBuilder iBuilder) {
            this.field_216042_b.add(iBuilder.func_216052_b());
            return this;
        }

        @Override
        public Builder func_212862_c_() {
            return this;
        }

        public LootTable func_216038_b() {
            return new LootTable(this.field_216043_c, this.field_216041_a.toArray(new LootPool[0]), this.field_216042_b.toArray(new ILootFunction[0]));
        }

        @Override
        public /* synthetic */ Object func_212862_c_() {
            return this.func_212862_c_();
        }

        @Override
        public /* synthetic */ Object func_212841_b_(ILootFunction.IBuilder iBuilder) {
            return this.func_212841_b_(iBuilder);
        }
    }
}

